/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.validators.N4JSClassValidator;
import org.eclipse.n4js.validation.validators.N4JSEnumValidator;
import org.eclipse.n4js.validation.validators.N4JSFunctionValidator;
import org.eclipse.n4js.validation.validators.N4JSInterfaceValidator;

public class StaticPolyfillValidatorExtension {
    public static void internalCheckNotInStaticPolyfillModule(N4InterfaceDeclaration n4InterfaceDeclaration, N4JSInterfaceValidator host) {
        boolean _isContainedInStaticPolyfillModule = N4JSLanguageUtils.isContainedInStaticPolyfillModule((AnnotableElement)n4InterfaceDeclaration);
        if (_isContainedInStaticPolyfillModule) {
            String msg = IssueCodes.getMessageForPOLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES();
            host.addIssue(msg, (EObject)n4InterfaceDeclaration, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES", new String[0]);
        }
    }

    public static void internalCheckNotInStaticPolyfillModule(N4EnumDeclaration n4EnumDecl, N4JSEnumValidator host) {
        boolean _isContainedInStaticPolyfillModule = N4JSLanguageUtils.isContainedInStaticPolyfillModule((AnnotableElement)n4EnumDecl);
        if (_isContainedInStaticPolyfillModule) {
            String msg = IssueCodes.getMessageForPOLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES();
            host.addIssue(msg, (EObject)n4EnumDecl, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES", new String[0]);
        }
    }

    public static void internalCheckNotInStaticPolyfillModule(FunctionDeclaration functionDeclaration, N4JSFunctionValidator host) {
        boolean _isContainedInStaticPolyfillModule;
        EObject cont = functionDeclaration.eContainer();
        while (cont instanceof ExportDeclaration) {
            cont = ((ExportDeclaration)cont).eContainer();
        }
        if (cont instanceof Script && (_isContainedInStaticPolyfillModule = N4JSLanguageUtils.isContainedInStaticPolyfillModule((AnnotableElement)functionDeclaration))) {
            String msg = IssueCodes.getMessageForPOLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES();
            host.addIssue(msg, (EObject)functionDeclaration, (EStructuralFeature)N4JSPackage.Literals.FUNCTION_DECLARATION__NAME, "POLY_STATIC_POLYFILL_MODULE_ONLY_FILLING_CLASSES", new String[0]);
        }
    }

    public static void internalCheckPolyFilledClassWithAdditionalInterface(N4ClassDeclaration classDeclaration, N4JSClassValidator host) {
        boolean _isStaticPolyfill = N4JSLanguageUtils.isStaticPolyfill((AnnotableElement)classDeclaration);
        if (_isStaticPolyfill) {
            boolean _not;
            boolean _isEmpty = classDeclaration.getImplementedInterfaceRefs().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                String msg = IssueCodes.getMessageForPOLY_IMPLEMENTING_INTERFACE_NOT_ALLOWED();
                host.addIssue(msg, (EObject)classDeclaration, (EStructuralFeature)N4JSPackage.Literals.N4_CLASS_DEFINITION__IMPLEMENTED_INTERFACE_REFS, "POLY_IMPLEMENTING_INTERFACE_NOT_ALLOWED", new String[0]);
            }
        }
    }
}

