/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.helper.AbstractCliTest;
import org.eclipse.n4js.cli.helper.CliCompileProcessResult;
import org.eclipse.n4js.cli.helper.CliCompileResult;
import org.eclipse.n4js.cli.helper.CliTools;
import org.eclipse.n4js.cli.helper.N4CliHelper;
import org.eclipse.n4js.cli.helper.ProcessResult;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.io.FileUtils;
import org.junit.Before;

public class AbstractCliCompileTest
extends AbstractCliTest<N4jscOptions> {
    private static final String WSP = "wsp";
    protected static final String PACKAGES = "packages";
    protected static final String FIXTURE = "probands";
    protected static final String TEST_DATA_SET__TESTERS = "testers";
    protected static final String TEST_DATA_SET__NPM_SCOPES = "npmScopes";
    private final N4jscVariant variant;
    private CliTools cliTools;

    public AbstractCliCompileTest() {
        this(N4jscVariant.inprocess);
    }

    public AbstractCliCompileTest(N4jscVariant variant) {
        this.variant = variant;
    }

    @Before
    public final void setupTestProcessExecuter() {
        this.cliTools = new CliTools();
    }

    @Override
    public CliCompileResult createResult() {
        CliCompileResult result = null;
        switch (this.variant) {
            case inprocess: {
                result = new CliCompileResult();
                break;
            }
            case exprocess: {
                result = new CliCompileProcessResult();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    @Override
    public void doN4jsc(N4jscOptions options, boolean removeUsage, CliCompileResult result) {
        switch (this.variant) {
            case inprocess: {
                this.cliTools.callN4jscInprocess(options, removeUsage, result);
                return;
            }
            case exprocess: {
                this.cliTools.callN4jscExprocess(options, removeUsage, (CliCompileProcessResult)result);
                return;
            }
        }
        throw new IllegalStateException();
    }

    public void setEnvironmentVariable(String name, String value) {
        this.cliTools.setEnvironmentVariable(name, value);
    }

    public ProcessResult runNodejs(Path workingDir, Path runFile, String ... options) {
        return this.cliTools.runNodejs(workingDir, runFile, options);
    }

    public ProcessResult npmInstall(Path workingDir, String ... options) {
        return this.cliTools.npmInstall(workingDir, options);
    }

    public ProcessResult npmList(Path workingDir, String ... options) {
        return this.cliTools.npmList(workingDir, options);
    }

    public ProcessResult yarnInstall(Path workingDir, String ... options) {
        return this.cliTools.yarnInstall(workingDir, options);
    }

    protected static File setupWorkspace(String testDataSet, boolean createYarnWorkspace) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(testDataSet, (Predicate<N4JSProjectName>)Predicates.alwaysFalse(), createYarnWorkspace);
    }

    protected static File setupWorkspace(String testDataRoot, String testDataSet, boolean createYarnWorkspace) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(testDataRoot, testDataSet, (Predicate<N4JSProjectName>)Predicates.alwaysFalse(), createYarnWorkspace);
    }

    protected static File setupWorkspace(String testDataSet, boolean createYarnWorkspace, N4JSProjectName ... libNames) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(testDataSet, (Predicate<N4JSProjectName>)((Predicate)libName -> Arrays.asList(libNames).contains(libName)), createYarnWorkspace);
    }

    protected static File setupWorkspace(String testDataSet, Predicate<N4JSProjectName> n4jsLibrariesPredicate, boolean createYarnWorkspace) throws IOException {
        return AbstractCliCompileTest.setupWorkspace(FIXTURE, testDataSet, n4jsLibrariesPredicate, createYarnWorkspace);
    }

    private static File setupWorkspace(String testDataRoot, String testDataSet, Predicate<N4JSProjectName> n4jsLibrariesPredicate, boolean createYarnWorkspace) throws IOException {
        Path fixture = new File(testDataRoot, testDataSet).toPath();
        Path root = FileUtils.createTempDirectory((String)(String.valueOf(testDataRoot) + "_" + testDataSet + "_"));
        root = root.toFile().getCanonicalFile().toPath();
        Path wsp = root.resolve(WSP);
        N4CliHelper.setupWorkspace(fixture, wsp, n4jsLibrariesPredicate, createYarnWorkspace);
        return wsp.toFile();
    }

    public static enum N4jscVariant {
        inprocess,
        exprocess;

    }
}

