/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.setup;

import com.google.common.base.Joiner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.xpect.AbstractComponent;
import org.eclipse.xpect.Assignment;
import org.eclipse.xpect.BooleanLiteral;
import org.eclipse.xpect.ClassLiteral;
import org.eclipse.xpect.Component;
import org.eclipse.xpect.IntLiteral;
import org.eclipse.xpect.StringLiteral;
import org.eclipse.xpect.Value;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.util.IJavaReflectAccess;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;

public class SetupInitializer<T>
implements ISetupInitializer<T> {
    private final AbstractComponent rootInstance;

    public SetupInitializer(AbstractComponent rootInstance) {
        this.rootInstance = rootInstance;
    }

    protected Object create(BooleanLiteral val) {
        return val.isValue();
    }

    protected Object create(ClassLiteral val) {
        return IJavaReflectAccess.INSTANCE.getRawType((JvmType)val.getType());
    }

    protected Object create(Component val) {
        Class<?> type = IJavaReflectAccess.INSTANCE.getRawType((JvmType)val.getComponentClass());
        try {
            Object[] params = new Object[val.getParameters().size()];
            int i = 0;
            while (i < val.getParameters().size()) {
                params[i] = this.create((Value)val.getParameters().get(i));
                ++i;
            }
            Constructor<?> constructor = this.findConstructor(type, params);
            Object result = constructor.newInstance(params);
            this.initialize(result, val);
            return result;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object create(IntLiteral val) {
        return val.getValue();
    }

    protected Object create(StringLiteral val) {
        return val.getValue();
    }

    protected Object create(Value val) {
        if (val instanceof Component) {
            return this.create((Component)val);
        }
        if (val instanceof BooleanLiteral) {
            return this.create((BooleanLiteral)val);
        }
        if (val instanceof StringLiteral) {
            return this.create((StringLiteral)val);
        }
        if (val instanceof IntLiteral) {
            return this.create((IntLiteral)val);
        }
        if (val instanceof ClassLiteral) {
            return this.create((ClassLiteral)val);
        }
        return null;
    }

    protected Constructor<?> findConstructor(Class<?> clazz, Object[] params) {
        Constructor<?> c;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                c = constructorArray[n2];
                if (c.getParameterTypes().length == params.length) {
                    int i = 0;
                    while (i < params.length) {
                        if (c.getParameterTypes()[i].isInstance(params[i])) {
                            ++i;
                            continue;
                        }
                        break block8;
                    }
                    return c;
                }
            }
            ++n2;
        }
        constructorArray = clazz.getConstructors();
        n = constructorArray.length;
        n2 = 0;
        while (n2 < n) {
            block9: {
                Class<?> aType;
                c = constructorArray[n2];
                if (c.getParameterTypes().length == 1 && (aType = c.getParameterTypes()[0]).isArray()) {
                    Class<?> cType = aType.getComponentType();
                    int i = 0;
                    while (i < params.length) {
                        if (cType.isInstance(params[i])) {
                            ++i;
                            continue;
                        }
                        break block9;
                    }
                    return c;
                }
            }
            ++n2;
        }
        throw new RuntimeException("Type " + clazz + " has no constructor suitable for params " + Joiner.on((String)", ").join(params));
    }

    protected Method findMethod(Object target, Assignment assignment) {
        Class<?> toBeAssignedJava;
        JvmDeclaredType toBeAssigned;
        JvmOperation result = assignment.getDeclaredTarget();
        if (result != null) {
            if (result.eIsProxy()) {
                throw new RuntimeException("unresolved proxy:" + result);
            }
            return IJavaReflectAccess.INSTANCE.getMethod(result);
        }
        Value val = assignment.getValue();
        if (val instanceof Component && (toBeAssigned = ((Component)val).getComponentClass()) != null && !toBeAssigned.eIsProxy() && (toBeAssignedJava = IJavaReflectAccess.INSTANCE.getRawType((JvmType)toBeAssigned)) != null) {
            Method[] methodArray = target.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> parameterType;
                Method candidate = methodArray[n2];
                if ("add".equals(candidate.getName()) && candidate.getParameterTypes().length == 1 && (parameterType = candidate.getParameterTypes()[0]).isAssignableFrom(toBeAssignedJava)) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    public AbstractComponent getRootInstance() {
        return this.rootInstance;
    }

    protected void initialize(Object obj, AbstractComponent init) {
        for (Assignment a : init.getAssignments()) {
            Method m = this.findMethod(obj, a);
            if (m == null) continue;
            Object object = this.create(a.getValue());
            try {
                m.invoke(obj, object);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void initialize(T object) {
        if (this.rootInstance != null) {
            this.initialize(object, this.rootInstance);
        }
    }
}

