/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.dependencies;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.n4js.ui.wizard.dependencies.ProjectsSettingsFilesLocator;

public class RunnableSettingsFilesLocator
implements IRunnableWithProgress {
    private static final Logger LOGGER = Logger.getLogger(RunnableSettingsFilesLocator.class);
    private ProjectsSettingsFilesLocator files = null;

    public synchronized void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int projectsCount = ResourcesPlugin.getWorkspace().getRoot().getProjects().length;
        int estimate = projectsCount > 0 ? projectsCount : 100;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(3 * estimate));
        SubMonitor subMonitor0 = subMonitor.split(estimate);
        this.refreshWorkspace((IProgressMonitor)subMonitor0);
        SubMonitor subMonitor1 = subMonitor.split(2 * estimate);
        this.files = ProjectsSettingsFilesLocator.findFiles((IProgressMonitor)subMonitor1);
    }

    private void refreshWorkspace(IProgressMonitor monitor) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            LOGGER.error((Object)"Error when refreshing workspace", (Throwable)e);
        }
    }

    public synchronized Collection<File> getCollectedConfigFiles() {
        if (this.files == null) {
            return Collections.emptySet();
        }
        return this.files.getNPMRCs();
    }
}

