/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.quickfix;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.xpect.registry.DefaultBinding;
import org.eclipse.xpect.ui.quickfix.XpectQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProviderExtension;
import org.eclipse.xtext.validation.Issue;

public class XtIssueResolutionProvider
implements IssueResolutionProvider,
IssueResolutionProviderExtension {
    @Inject
    @DefaultBinding
    private IssueResolutionProvider original;
    @Inject
    private XpectQuickfixProvider xpect;

    public boolean hasResolutionFor(String issueCode) {
        return this.xpect.hasExplicitResolutionFor(issueCode) || this.original.hasResolutionFor(issueCode);
    }

    public List<IssueResolution> getResolutions(Issue issue) {
        if (this.xpect.hasExplicitResolutionFor(issue.getCode())) {
            return this.xpect.getResolutions(issue);
        }
        return this.original.getResolutions(issue);
    }

    public boolean hasResolutionFor(Issue issue) {
        if (this.xpect.hasExplicitResolutionFor(issue.getCode())) {
            return true;
        }
        if (this.original instanceof IssueResolutionProviderExtension) {
            return ((IssueResolutionProviderExtension)this.original).hasResolutionFor(issue);
        }
        return false;
    }
}

