/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.contentassist;

import com.google.inject.Inject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.n4js.ui.utils.ConfigurableCompletionProposalExtensions;
import org.eclipse.n4js.ui.utils.PrefixMatcherHelper;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentProposalPriorities;

public class N4JSContentProposalPriorities
extends ContentProposalPriorities {
    protected float sameCaseMultiplier = 1.1f;
    protected float secondaryMemberMultiplier = 0.95f;
    @Inject
    private PrefixMatcherHelper prefixMatcherHelper;

    public N4JSContentProposalPriorities() {
        this.sameTextMultiplier = this.proposalWithPrefixMultiplier;
    }

    protected void adjustPriority(ICompletionProposal proposal, String prefix, int priority) {
        super.adjustPriority(proposal, prefix, priority);
        if (proposal instanceof ConfigurableCompletionProposal) {
            ConfigurableCompletionProposal proposalCasted = (ConfigurableCompletionProposal)proposal;
            String replacement = proposalCasted.getReplacementString();
            if (!prefix.isEmpty() && this.isPrefixWithMatchingCase(prefix, replacement)) {
                this.adjustPriorityByFactor(proposalCasted, this.sameCaseMultiplier);
            }
            if (ConfigurableCompletionProposalExtensions.isSecondaryMember(proposalCasted)) {
                this.adjustPriorityByFactor(proposalCasted, this.secondaryMemberMultiplier);
            }
        }
    }

    private void adjustPriorityByFactor(ConfigurableCompletionProposal proposal, float factor) {
        if (factor == 1.0f) {
            return;
        }
        int newPrio = (int)((float)proposal.getPriority() * factor);
        proposal.setPriority(newPrio);
    }

    private boolean isPrefixWithMatchingCase(String prefix, String str) {
        return str.startsWith(prefix) || this.prefixMatcherHelper.camelCaseMatch(str, prefix);
    }
}

