/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.handler;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.wizard.classifiers.N4JSNewClassifierWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CreateNewN4JSElementInModuleHandler
extends AbstractHandler {
    private static final String WIZARD_ID_PARAMETER_ID = "org.eclipse.n4js.ui.wizard.CreateNewN4JSElementInModule.wizardId";
    private static final String NESTED_PARAMETER_ID = "org.eclipse.n4js.ui.wizard.CreateNewN4JSElementInModule.nested";
    @Inject
    Injector injector;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        StructuredSelection selection;
        String wizardId = event.getParameter(WIZARD_ID_PARAMETER_ID);
        if (wizardId == null) {
            return null;
        }
        boolean isNested = Boolean.parseBoolean(event.getParameter(NESTED_PARAMETER_ID));
        IFile editorFile = CreateNewN4JSElementInModuleHandler.getActiveEditorFile();
        if (editorFile != null) {
            selection = new StructuredSelection((Object)editorFile);
        } else {
            IResource resourceTreeFile = CreateNewN4JSElementInModuleHandler.getActiveTreeResourceSelection(event);
            if (resourceTreeFile != null) {
                isNested = false;
                selection = new StructuredSelection((Object)resourceTreeFile);
            } else {
                selection = StructuredSelection.EMPTY;
            }
        }
        this.openWizardForModule(wizardId, (IStructuredSelection)selection, isNested);
        return null;
    }

    private static IFile getActiveEditorFile() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        IEditorInput input = activeEditor.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    private static IResource getActiveTreeResourceSelection(ExecutionEvent event) {
        Object firstElement;
        ISelection activeSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (activeSelection instanceof TreeSelection && (firstElement = ((TreeSelection)activeSelection).getFirstElement()) instanceof IResource) {
            return (IResource)firstElement;
        }
        return null;
    }

    private void openWizardForModule(String wizardId, IStructuredSelection selection, boolean nested) {
        IWizardDescriptor wizardDescriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(wizardId);
        if (wizardDescriptor == null) {
            return;
        }
        try {
            IWorkbenchWizard wizard = wizardDescriptor.createWizard();
            this.injector.injectMembers((Object)wizard);
            WizardDialog wizardDialog = new WizardDialog(UIUtils.getShell(), (IWizard)wizard);
            if (wizard instanceof N4JSNewClassifierWizard) {
                ((N4JSNewClassifierWizard)wizard).init(PlatformUI.getWorkbench(), selection, nested);
            } else {
                wizard.init(PlatformUI.getWorkbench(), selection);
            }
            wizardDialog.open();
        }
        catch (CoreException e) {
            Shell workbenchShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.open((int)1, (Shell)workbenchShell, (String)"Failed to launch wizard", (String)String.format("Failed to launch wizard %s", wizardId), (int)0x10000000);
            return;
        }
    }
}

