/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup.workspace;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectRequiredEnvironment;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.setup.XpectSetupRoot;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.xtext.lib.setup.InjectorSetup;
import org.eclipse.xpect.xtext.lib.setup.generic.Resource;
import org.eclipse.xpect.xtext.lib.setup.workspace.File;
import org.eclipse.xpect.xtext.lib.setup.workspace.Folder;
import org.eclipse.xpect.xtext.lib.setup.workspace.IResourceFactory;
import org.eclipse.xpect.xtext.lib.setup.workspace.JavaProject;
import org.eclipse.xpect.xtext.lib.setup.workspace.Project;
import org.eclipse.xpect.xtext.lib.setup.workspace.SrcFolder;
import org.eclipse.xpect.xtext.lib.setup.workspace.ThisFile;
import org.eclipse.xpect.xtext.lib.setup.workspace.Workspace;
import org.eclipse.xpect.xtext.lib.util.GrammarAnalyzer;
import org.eclipse.xtext.IGrammarAccess;

@XpectSetupRoot
@XpectSetupFactory
@XpectRequiredEnvironment(value={Environment.PLUGIN_TEST})
@XpectImport(value={InjectorSetup.class, File.class, Folder.class, JavaProject.class, Project.class, SrcFolder.class, ThisFile.class})
public class WorkspaceDefaultsSetup {
    private static final Logger LOG = Logger.getLogger(WorkspaceDefaultsSetup.class);
    public static final Path XTEND_LIBRARY_PATH = new Path("org.eclipse.xtend.XTEND_CONTAINER");
    private List<Resource> genericResources = Lists.newArrayList();
    private Workspace workspace;

    public WorkspaceDefaultsSetup(ISetupInitializer<WorkspaceDefaultsSetup> initializer, Injector injector) {
        this.initialize(initializer, injector);
    }

    public void add(Resource file) {
        this.genericResources.add(file);
    }

    public void add(Workspace workspace) {
        if (this.workspace != null) {
            throw new IllegalStateException("Only one workspace per setup is supported.");
        }
        this.workspace = workspace;
    }

    protected IResourceFactory<? extends IResource, IContainer> convert(Resource res) {
        if (res instanceof org.eclipse.xpect.xtext.lib.setup.generic.ThisFile) {
            return new ThisFile((org.eclipse.xpect.xtext.lib.setup.generic.ThisFile)res);
        }
        if (res instanceof org.eclipse.xpect.xtext.lib.setup.generic.File) {
            return new File((org.eclipse.xpect.xtext.lib.setup.generic.File)res);
        }
        if (res instanceof org.eclipse.xpect.xtext.lib.setup.generic.Folder) {
            return new Folder((org.eclipse.xpect.xtext.lib.setup.generic.Folder)res);
        }
        throw new IllegalStateException();
    }

    protected Workspace createWorkspace() {
        return new Workspace();
    }

    public List<Resource> getGenericResources() {
        return this.genericResources;
    }

    @Creates
    public Workspace getWorkspace() {
        return this.workspace;
    }

    protected void initialize(ISetupInitializer<WorkspaceDefaultsSetup> initializer, Injector injector) {
        initializer.initialize((Object)this);
        if (this.workspace == null) {
            this.add(this.createWorkspace());
        }
        this.initializeProject(injector);
    }

    protected void initializeDefaultProject() {
        if (this.workspace.getDefaultProject() == null) {
            this.workspace.add(new Project("default_project"));
        }
        Project defaultProject = this.workspace.getDefaultProject();
        for (Resource res : this.getGenericResources()) {
            defaultProject.add(this.convert(res));
        }
        if (this.workspace.getThisFile() == null) {
            defaultProject.add(new ThisFile());
        }
    }

    protected void initializeJavaProject() {
        if (this.workspace.getMember(JavaProject.class) == null) {
            this.workspace.add(new JavaProject("default_java_project"));
        }
        JavaProject javaProject = this.workspace.getMember(JavaProject.class);
        this.initializeJavaProject(javaProject);
    }

    protected void initializeJavaProject(JavaProject javaProject) {
        if (javaProject.getMember(SrcFolder.class) == null) {
            javaProject.add(new SrcFolder("src"));
        }
        SrcFolder srcFolder = javaProject.getMember(SrcFolder.class);
        for (Resource res : this.getGenericResources()) {
            srcFolder.add(this.convert(res));
        }
        if (this.workspace.getThisFile() == null) {
            srcFolder.add(new ThisFile());
        }
    }

    protected void initializeProject(Injector injector) {
        GrammarAnalyzer ga = new GrammarAnalyzer(((IGrammarAccess)injector.getInstance(IGrammarAccess.class)).getGrammar());
        switch (ga.getLanguageKind()) {
            case XBASE: {
                this.initializeXbaseProject();
                break;
            }
            case JAVA: {
                this.initializeJavaProject();
                break;
            }
            default: {
                this.initializeDefaultProject();
            }
        }
    }

    protected void initializeXbaseProject() {
        LOG.warn((Object)"Can't add xbase dependencies to test project; org.eclipse.xpect.xtext.xbase.lib.XbaseWorkspaceDefaultsSetup not loaded.");
        this.initializeJavaProject();
    }
}

