/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.Similarity;

public final class LeafSimScorer {
    private final Similarity.SimScorer scorer;
    private final NumericDocValues norms;

    public LeafSimScorer(Similarity.SimScorer scorer, LeafReader reader, String field, boolean needsScores) throws IOException {
        this.scorer = Objects.requireNonNull(scorer);
        this.norms = needsScores ? reader.getNormValues(field) : null;
    }

    public Similarity.SimScorer getSimScorer() {
        return this.scorer;
    }

    private long getNormValue(int doc) throws IOException {
        if (this.norms != null) {
            boolean found = this.norms.advanceExact(doc);
            assert (found);
            return this.norms.longValue();
        }
        return 1L;
    }

    public float score(int doc, float freq) throws IOException {
        return this.scorer.score(freq, this.getNormValue(doc));
    }

    public Explanation explain(int doc, Explanation freqExpl) throws IOException {
        return this.scorer.explain(freqExpl, this.getNormValue(doc));
    }
}

