/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.external.ExternalIndexSynchronizer;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.ui.internal.EclipseBasedN4JSWorkspace;
import org.eclipse.n4js.ui.internal.ResourceUIValidatorExtension;

@Singleton
public class EclipseExternalIndexSynchronizer
extends ExternalIndexSynchronizer {
    @Inject
    private ResourceUIValidatorExtension validatorExtension;
    @Inject
    private EclipseBasedN4JSWorkspace workspace;

    public void synchronizeNpms(IProgressMonitor monitor) {
        this.synchronizeNpms(monitor, Collections.emptyList());
    }

    public void synchronizeNpms(IProgressMonitor monitor, Collection<LibraryChange> forcedChangeSet) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        try {
            try {
                this.workspace.getWorkspace().refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
                Collection changesSet = this.identifyChangeSet(forcedChangeSet, ExternalIndexSynchronizer.ProjectStateOperation.UPDATE);
                ExternalLibraryWorkspace.RegisterResult cleanResults = this.cleanChangesIndex((IProgressMonitor)subMonitor.split(1), changesSet);
                this.buildChangesIndex((IProgressMonitor)subMonitor.split(9), changesSet, cleanResults);
            }
            catch (Exception e) {
                this.checkAndClearIndex((IProgressMonitor)subMonitor.split(1));
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private ExternalLibraryWorkspace.RegisterResult cleanChangesIndex(IProgressMonitor monitor, Collection<LibraryChange> changeSet) {
        try {
            monitor.setTaskName("Cleaning new projects...");
            Set<FileURI> toBeRemovedProjects = this.getToBeRemovedProjects(changeSet);
            ExternalLibraryWorkspace.RegisterResult cleanResults = this.externalLibraryWorkspace.deregisterProjects(monitor, toBeRemovedProjects);
            this.printRegisterResults(cleanResults, "cleaned");
            ExternalLibraryWorkspace.RegisterResult registerResult = cleanResults;
            return registerResult;
        }
        finally {
            monitor.done();
        }
    }

    private void buildChangesIndex(IProgressMonitor monitor, Collection<LibraryChange> changeSet, ExternalLibraryWorkspace.RegisterResult cleanResults) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            Set<FileURI> toBeUpdated = this.getToBeBuildProjects(changeSet);
            for (FileURI cleanedPrjLoc : cleanResults.externalProjectsDone) {
                N4JSExternalProject project = this.externalLibraryWorkspace.getProject(cleanedPrjLoc);
                if (project == null) continue;
                toBeUpdated.add(cleanedPrjLoc);
            }
            subMonitor.setTaskName("Building new projects...");
            ExternalLibraryWorkspace.RegisterResult buildResult = this.externalLibraryWorkspace.registerProjects((IProgressMonitor)subMonitor.split(9), toBeUpdated);
            this.printRegisterResults(buildResult, "built");
            HashSet toBeScheduled = new HashSet();
            toBeScheduled.addAll(cleanResults.affectedWorkspaceProjects);
            toBeScheduled.addAll(buildResult.affectedWorkspaceProjects);
            this.externalLibraryWorkspace.scheduleWorkspaceProjects((IProgressMonitor)subMonitor.split(1), toBeScheduled);
        }
        finally {
            subMonitor.done();
        }
    }

    public void reindexAllExternalProjects(IProgressMonitor monitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)11);
            monitor.setTaskName("Cleaning all projects...");
            this.externalLibraryWorkspace.deregisterAllProjects((IProgressMonitor)subMonitor.split(1));
            this.validatorExtension.clearAllMarkersOfAllExternalProjects();
            this.synchronizeNpms((IProgressMonitor)subMonitor.split(10));
        }
        finally {
            monitor.done();
        }
    }

    private Set<FileURI> getToBeRemovedProjects(Collection<LibraryChange> changeSet) {
        HashSet<FileURI> toBeDeleted = new HashSet<FileURI>();
        for (LibraryChange change : changeSet) {
            switch (change.type) {
                case Added: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.name);
                    if (project == null) break;
                    toBeDeleted.add(project.getSafeLocation());
                    break;
                }
                case Removed: 
                case Updated: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.location);
                    toBeDeleted.add(change.location);
                }
            }
        }
        return toBeDeleted;
    }

    private Set<FileURI> getToBeBuildProjects(Collection<LibraryChange> changeSet) {
        HashSet<FileURI> toBeUpdated = new HashSet<FileURI>();
        for (LibraryChange change : changeSet) {
            switch (change.type) {
                case Added: 
                case Updated: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.location);
                    if (project != null) {
                        toBeUpdated.add(change.location);
                        break;
                    }
                    String msg = "ERROR: The project '" + change.name + "' was " + change.type;
                    msg = String.valueOf(msg) + " but could not be found at " + change.location + ".\n";
                    msg = String.valueOf(msg) + "       Hence, the project is not available in the workspace.";
                    this.logger.logInfo(msg);
                    break;
                }
                case Removed: {
                    N4JSExternalProject project = this.externalLibraryWorkspace.getProject(change.name);
                    if (project == null) break;
                    toBeUpdated.add(project.getSafeLocation());
                }
            }
        }
        return toBeUpdated;
    }
}

