/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.preferences;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.URIUtils;

public class ExternalLibraryPreferenceModel {
    private static final String PROP_EXTERNAL_LIBRARY_LOCATIONS = "externalLibraryLocations";
    private final List<FileURI> externalLibraryLocations = Lists.newArrayList();
    private final LinkedHashSet<FileURI> externalLibraryLocationURIs = new LinkedHashSet();
    private final LinkedHashSet<FileURI> externalNodeModulesURIs = new LinkedHashSet();
    private long externalLibraryLocationURIsHash = 0L;

    public static ExternalLibraryPreferenceModel createDefault() {
        FileURI home = new FileURI(new File(StandardSystemProperty.USER_HOME.value()));
        return new ExternalLibraryPreferenceModel(home, new FileURI[0]);
    }

    public static ExternalLibraryPreferenceModel createDefaultForN4Product() {
        Preconditions.checkState((boolean)Platform.isRunning(), (Object)"Expected running platform.");
        return new ExternalLibraryPreferenceModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalLibraryPreferenceModel createFromJson(String jsonString) {
        ExternalLibraryPreferenceModel result;
        JSONDocument document = JSONModelUtils.parseJSON((String)jsonString);
        if (document == null) {
            throw new RuntimeException("Error occurred while trying to parse JSON string.");
        }
        JSONValue extLibLocsValue = JSONModelUtils.getProperty((JSONDocument)document, (String)PROP_EXTERNAL_LIBRARY_LOCATIONS).orElse(null);
        List extLibLocs = JSONModelUtils.asStringsInArrayOrEmpty((JSONValue)extLibLocsValue);
        ExternalLibraryPreferenceModel externalLibraryPreferenceModel = result = new ExternalLibraryPreferenceModel();
        synchronized (externalLibraryPreferenceModel) {
            for (String extLibLoc : extLibLocs) {
                FileURI fileUri = new FileURI(URIUtils.toFileUri((String)extLibLoc));
                result.externalLibraryLocations.add(fileUri);
            }
        }
        return result;
    }

    public ExternalLibraryPreferenceModel() {
        this(Collections.emptyList());
    }

    public ExternalLibraryPreferenceModel(FileURI firstLocation, FileURI ... restLocations) {
        this(Lists.asList((Object)firstLocation, (Object[])restLocations));
    }

    public ExternalLibraryPreferenceModel(List<FileURI> locations) {
        for (FileURI location : locations) {
            if (this.externalLibraryLocations.contains(location)) continue;
            this.externalLibraryLocations.add(location);
        }
    }

    public List<SafeURI<?>> getExternalLibraryLocations() {
        return Collections.unmodifiableList(this.externalLibraryLocations);
    }

    public synchronized boolean add(FileURI location) {
        if (location == null) {
            return false;
        }
        if (this.externalLibraryLocations.contains(location)) {
            return false;
        }
        return this.externalLibraryLocations.add(location);
    }

    public synchronized boolean remove(FileURI location) {
        if (location == null) {
            return false;
        }
        return this.externalLibraryLocations.removeAll(Collections.singleton(location));
    }

    public synchronized void moveUp(FileURI location) {
        int indexOf;
        if (location != null && (indexOf = this.externalLibraryLocations.indexOf(location)) > 0) {
            this.externalLibraryLocations.remove(indexOf);
            this.externalLibraryLocations.add(indexOf - 1, location);
        }
    }

    public synchronized void moveDown(FileURI location) {
        int indexOf;
        if (location != null && (indexOf = this.externalLibraryLocations.indexOf(location)) >= 0 && indexOf < this.externalLibraryLocations.size() - 1) {
            this.externalLibraryLocations.remove(indexOf);
            this.externalLibraryLocations.add(indexOf + 1, location);
        }
    }

    public synchronized LinkedHashSet<FileURI> getExternalLibraryLocationsAsUris() {
        boolean needUpdate;
        int currentHash = this.externalLibraryLocations.hashCode();
        boolean bl = needUpdate = (long)currentHash != this.externalLibraryLocationURIsHash;
        if (needUpdate) {
            this.externalLibraryLocationURIsHash = currentHash;
            List<FileURI> locations = new LinkedList<FileURI>();
            for (FileURI projectLocation : this.externalLibraryLocations) {
                locations.add(projectLocation);
            }
            locations = ExternalLibraryHelper.sortByShadowing(locations);
            this.externalLibraryLocationURIs.clear();
            this.externalLibraryLocationURIs.addAll(locations);
            this.externalNodeModulesURIs.clear();
            for (FileURI location : locations) {
                if (!ExternalLibraryPreferenceModel.isNodeModulesLocation(location)) continue;
                this.externalNodeModulesURIs.add(location);
            }
        }
        return this.externalLibraryLocationURIs;
    }

    public static boolean isNodeModulesLocation(SafeURI<?> location) {
        String locStr = location.toString();
        if (locStr.endsWith("/")) {
            return locStr.endsWith("node_modules/");
        }
        return locStr.endsWith("node_modules");
    }

    public synchronized Collection<FileURI> getNodeModulesLocationsAsUris() {
        return this.externalNodeModulesURIs;
    }

    public synchronized String toJsonString() {
        JSONArray extLibLocsValue = JSONModelUtils.createStringArray(() -> this.externalLibraryLocations.stream().map(Object::toString).iterator());
        JSONObject obj = JSONModelUtils.createObject((Map)ImmutableMap.of((Object)PROP_EXTERNAL_LIBRARY_LOCATIONS, (Object)extLibLocsValue));
        JSONDocument doc = JSONModelUtils.createDocument((JSONValue)obj);
        return JSONModelUtils.serializeJSON((JSONDocument)doc);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalLibraryLocations == null ? 0 : this.externalLibraryLocations.hashCode());
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalLibraryPreferenceModel)) {
            return false;
        }
        ExternalLibraryPreferenceModel other = (ExternalLibraryPreferenceModel)obj;
        return !(this.externalLibraryLocations == null ? other.externalLibraryLocations != null : !this.externalLibraryLocations.equals(other.externalLibraryLocations));
    }

    public String toString() {
        return this.toJsonString();
    }
}

