/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.external;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.URI;
import java.nio.file.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NpmrcBinary;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.smith.Measurement;
import org.eclipse.n4js.smith.N4JSDataCollectors;

public class ExternalLibrariesActionsHelper {
    @Inject
    private LibraryManager libManager;
    @Inject
    private BinariesPreferenceStore binPreferenceStore;
    @Inject
    private Provider<NpmrcBinary> npmrcBinaryProvider;

    public void cleanAndInstallAllDependencies(Optional<Path> npmrcLocation, SubMonitor monitor, MultiStatus multiStatus) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Measurement m = N4JSDataCollectors.dcInstallHelper.getMeasurement("Install Missing Dependencies");){
            if (npmrcLocation.isPresent()) {
                this.configureNpmrc((Path)npmrcLocation.get(), multiStatus);
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            multiStatus.merge(this.maintenanceDeleteNpms((IProgressMonitor)subMonitor.split(1)));
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (Measurement mm = N4JSDataCollectors.dcInstallMissingDeps.getMeasurement("Install missing dependencies");){
                IStatus status = this.libManager.runNpmYarnInstallOnAllProjects((IProgressMonitor)subMonitor.split(1));
                if (!status.isOK()) {
                    multiStatus.merge(status);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void configureNpmrc(Path npmrcLocation, MultiStatus multiStatus) {
        NpmrcBinary npmrcBinary;
        URI oldLocation;
        URI newLocation = npmrcLocation.toFile().toURI();
        if (!newLocation.equals(oldLocation = (npmrcBinary = (NpmrcBinary)this.npmrcBinaryProvider.get()).getUserConfiguredLocation())) {
            this.binPreferenceStore.setPath((Binary)npmrcBinary, newLocation);
            IStatus save = this.binPreferenceStore.save();
            multiStatus.add(save);
        }
    }

    public IStatus maintenanceDeleteNpms(IProgressMonitor monitor) {
        return this.libManager.deleteAllNodeModulesFolders(monitor);
    }
}

