/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.scoping;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4idl.scoping.N4IDLVersionableFilter;
import org.eclipse.n4js.ts.types.TVersionable;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class N4IDLVersionAwareScope
implements IScope {
    private final IScope delegate;
    private final N4IDLVersionableFilter filter;

    public N4IDLVersionAwareScope(IScope delegate, int contextVersion) {
        N4IDLVersionableFilter _n4IDLVersionableFilter;
        if (contextVersion <= 0) {
            throw new IllegalArgumentException("Context version must be a positive integer");
        }
        this.delegate = Objects.requireNonNull(delegate);
        this.filter = _n4IDLVersionableFilter = new N4IDLVersionableFilter(contextVersion);
    }

    public Iterable<IEObjectDescription> getAllElements() {
        return this.delegate.getAllElements();
    }

    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        return this.filter.filterElements(this.delegate.getElements(name));
    }

    public Iterable<IEObjectDescription> getElements(EObject object) {
        return this.filter.filterElements(this.delegate.getElements(object));
    }

    public IEObjectDescription getSingleElement(QualifiedName name) {
        return this.selectElement(this.delegate.getElements(name));
    }

    public IEObjectDescription getSingleElement(EObject object) {
        return this.selectElement(this.delegate.getElements(object));
    }

    private IEObjectDescription selectElement(Iterable<IEObjectDescription> descriptions) {
        IEObjectDescription description = (IEObjectDescription)IterableExtensions.head(this.filter.filterElements(descriptions));
        if (description == null) {
            return null;
        }
        EObject element = description.getEObjectOrProxy();
        if (element instanceof TVersionable) {
            int _contextVersion;
            boolean _notEquals;
            int _version = ((TVersionable)element).getVersion();
            boolean bl = _notEquals = _version != (_contextVersion = this.filter.getContextVersion());
            if (_notEquals) {
                return description;
            }
        }
        return description;
    }

    public String toString() {
        int _contextVersion = this.filter.getContextVersion();
        String _plus = "N4IDLVersionAwareScope[contextVersion = " + Integer.valueOf(_contextVersion);
        String _plus_1 = String.valueOf(_plus) + "] -> ";
        String _string = this.delegate.toString();
        return String.valueOf(_plus_1) + _string;
    }
}

