/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.push.PushWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public class PushActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        PushWizard pushWizard;
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        try {
            pushWizard = new PushWizard(repository);
        }
        catch (URISyntaxException x) {
            ErrorDialog.openError((Shell)this.getShell(event), (String)UIText.PushAction_wrongURITitle, (String)UIText.PushAction_wrongURIDescription, (IStatus)new Status(4, Activator.getPluginId(), x.getMessage(), (Throwable)x));
            return null;
        }
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)pushWizard);
        dlg.setHelpAvailable(true);
        dlg.open();
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository repository;
        block3: {
            try {
                repository = this.getRepository();
                if (repository != null) break block3;
                return false;
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
                return false;
            }
        }
        Ref ref = repository.exactRef("HEAD");
        return ref != null && ref.getObjectId() != null;
    }
}

