/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.findReferences;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ts.findReferences.SimpleResourceAccess;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class HeadlessReferenceFinder {
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private Provider<TargetURIs> targetURIsProvider;
    @Inject
    private TargetURICollector uriCollector;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public List<IReferenceDescription> findReferencesTo(EObject target) {
        return this.findReferencesTo(target, null);
    }

    public List<IReferenceDescription> findReferencesTo(EObject target, IProgressMonitor monitor) {
        TargetURIs targetURIs = this.getTargetURIs(target);
        ResourceSet resourceSet = target.eResource().getResourceSet();
        final ArrayList result = Lists.newArrayList();
        SimpleResourceAccess resourceAccess = new SimpleResourceAccess(resourceSet);
        IReferenceFinder.Acceptor acceptor = new IReferenceFinder.Acceptor(){

            public void accept(IReferenceDescription description) {
                result.add(description);
            }

            public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
                this.accept((IReferenceDescription)new DefaultReferenceDescription(sourceURI, targetURI, eReference, index, null));
            }
        };
        this.referenceFinder.findAllReferences(targetURIs, (IReferenceFinder.IResourceAccess)resourceAccess, this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet), acceptor, monitor);
        return result;
    }

    private TargetURIs getTargetURIs(EObject primaryTarget) {
        TargetURIs result = (TargetURIs)this.targetURIsProvider.get();
        this.uriCollector.add(primaryTarget, result);
        return result;
    }
}

