/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets.internal;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.ui.workingsets.ManualAssociationAwareWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetDiffBuilder;
import org.eclipse.n4js.ui.workingsets.WorkingSetLabelProvider;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;

public class AssignWorkingSetsAction
extends SelectionListenerAction
implements ActionFactory.IWorkbenchAction {
    private static final String DIALOG_TITLE = "Working Set Assignment";
    private static final String DIALOG_SUBTITLE = "Select working sets (visible-only) for %d selected element(s)";
    @Inject
    private WorkingSetManagerBroker broker;
    private ICommonViewerSite site;

    public AssignWorkingSetsAction() {
        super("Assign Working Sets...");
    }

    public void init(ICommonActionExtensionSite extensionSite) {
        this.site = extensionSite.getViewSite();
    }

    public void run() {
        if (this.site == null) {
            return;
        }
        Object[] selectionElements = this.getStructuredSelection().toArray();
        Iterable selectionProjectNames = Arrays.asList(selectionElements).stream().filter(item -> item instanceof IProject).map(item -> ((IProject)item).getName()).collect(Collectors.toList());
        if (!(this.broker.getActiveManager() instanceof ManualAssociationAwareWorkingSetManager)) {
            return;
        }
        ListSelectionDialog dialog = this.createDialog(Arrays.asList(((ManualAssociationAwareWorkingSetManager)this.broker.getActiveManager()).getWorkingSets()), selectionElements.length);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        this.performWorkingSetUpdate(dialog.getResult(), selectionProjectNames);
    }

    private boolean performWorkingSetUpdate(Object[] dialogResult, Iterable<String> selectionProjectNames) {
        if (dialogResult == null) {
            return false;
        }
        WorkingSetManager workingSetManager = this.broker.getActiveManager();
        if (!(workingSetManager instanceof ManualAssociationAwareWorkingSetManager)) {
            return false;
        }
        ArrayList<WorkingSet> allWorkingSets = new ArrayList<WorkingSet>(Arrays.asList(workingSetManager.getAllWorkingSets()));
        ArrayList<WorkingSet> workingSets = new ArrayList<WorkingSet>(Arrays.asList(workingSetManager.getWorkingSets()));
        WorkingSetDiffBuilder builder = new WorkingSetDiffBuilder(workingSetManager);
        Object[] objectArray = dialogResult;
        int n = dialogResult.length;
        int n2 = 0;
        while (n2 < n) {
            Object resultItem = objectArray[n2];
            if (!(resultItem instanceof ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet)) {
                return false;
            }
            ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet oldState = (ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet)resultItem;
            ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet newState = this.getWorkingSetWithAddedProjects(oldState, selectionProjectNames);
            builder.edit(oldState, newState);
            this.replaceWorkingSet(workingSets, newState);
            this.replaceWorkingSet(allWorkingSets, newState);
            ++n2;
        }
        workingSetManager.updateState(builder.build(workingSets, allWorkingSets));
        this.broker.refreshNavigator();
        return true;
    }

    private ListSelectionDialog createDialog(Collection<WorkingSet> workingSets, int numberOfSelectedProjects) {
        List selectableWorkingSets = workingSets.stream().filter(set -> !set.getId().equals("Other Projects")).collect(Collectors.toList());
        String message = String.format(DIALOG_SUBTITLE, numberOfSelectedProjects);
        NonEmptyListSelectionDialog dialog = new NonEmptyListSelectionDialog(this.site.getShell(), selectableWorkingSets, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)WorkingSetLabelProvider.INSTANCE, message);
        dialog.setTitle(DIALOG_TITLE);
        return dialog;
    }

    private boolean replaceWorkingSet(List<WorkingSet> list, WorkingSet workingSet) {
        int replaceIndex = list.indexOf(workingSet);
        if (replaceIndex != -1) {
            list.set(replaceIndex, workingSet);
            return true;
        }
        return false;
    }

    private ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet getWorkingSetWithAddedProjects(ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet workingSet, Iterable<String> addedProjectNames) {
        Iterable mergedProjects = Iterables.concat(workingSet.getAssociatedProjectNames(), addedProjectNames);
        return new ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet(mergedProjects, workingSet.getName(), workingSet.getWorkingSetManager());
    }

    public boolean updateSelection(IStructuredSelection selection) {
        IProject[] selectedProjects;
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object[] selectedElements = selection.toArray();
        if (selectedElements.length != (selectedProjects = (IProject[])Arrays2.filter((Object[])selectedElements, IProject.class)).length) {
            return false;
        }
        return this.broker.getActiveManager() instanceof ManualAssociationAwareWorkingSetManager;
    }

    public void dispose() {
    }

    private static class NonEmptyListSelectionDialog
    extends ListSelectionDialog {
        public NonEmptyListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.getViewer().addCheckStateListener(event -> this.validateSelection());
            this.validateSelection();
            return control;
        }

        private void validateSelection() {
            this.getOkButton().setEnabled(this.getViewer().getCheckedElements().length > 0);
        }
    }
}

