/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.util.AccessorTuple;
import org.eclipse.n4js.ts.types.util.MemberList;
import org.eclipse.n4js.ts.types.util.NameStaticPair;
import org.eclipse.n4js.utils.ContainerTypesHelper;

public class ConcreteMembersOrderedForTranspiler {
    final List<TMember> concreteInheritedMembers;
    public final List<TMember> ownedAndMixedInConcreteMembers;
    public final List<AccessorTuple> concreteAccessorTuples;
    public final MemberList<TField> fieldsOverridingAccessors;
    public final MemberList<TField> fieldsPurelyMixedInNotOverridingAccessor;

    public static ConcreteMembersOrderedForTranspiler create(ContainerTypesHelper containerTypesHelper, TClassifier type, Script context) {
        ContainerTypesHelper.MemberCollector collector = containerTypesHelper.fromContext((EObject)context);
        MemberList concreteInheritedMembers = type instanceof TClass ? collector.inheritedMembers((TClass)type) : Collections.emptyList();
        MemberList ownedAndMixedInConcreteMembers = collector.computeOwnedAndMixedInConcreteMembers(type);
        List<AccessorTuple> concreteAccessorTuples = ConcreteMembersOrderedForTranspiler.getConcreteFieldAccessors((List<TMember>)ownedAndMixedInConcreteMembers, (List<TMember>)concreteInheritedMembers);
        MemberList<TField> fieldsOverridingAccessors = ConcreteMembersOrderedForTranspiler.getFieldsOverridingAccessor((Iterable<TMember>)ownedAndMixedInConcreteMembers, (List<TMember>)concreteInheritedMembers);
        MemberList fieldsPurelyMixedInNotOverridingAccessor = new MemberList();
        fieldsPurelyMixedInNotOverridingAccessor.addAll((Collection)ownedAndMixedInConcreteMembers.stream().filter(it -> it instanceof TField && it.getContainingType() != type).map(it -> (TField)it).filter(it -> !fieldsOverridingAccessors.contains(it)).collect(Collectors.toList()));
        return new ConcreteMembersOrderedForTranspiler((List<TMember>)concreteInheritedMembers, (List<TMember>)ownedAndMixedInConcreteMembers, concreteAccessorTuples, fieldsOverridingAccessors, (MemberList<TField>)fieldsPurelyMixedInNotOverridingAccessor);
    }

    private ConcreteMembersOrderedForTranspiler(List<TMember> concreteInheritedMembers, List<TMember> ownedAndMixedInConcreteMembers, List<AccessorTuple> concreteAccessorTuples, MemberList<TField> fieldsOverridingAccessors, MemberList<TField> fieldsPurelyMixedInNotOverridingAccessor) {
        this.concreteInheritedMembers = concreteInheritedMembers;
        this.ownedAndMixedInConcreteMembers = ownedAndMixedInConcreteMembers;
        this.concreteAccessorTuples = concreteAccessorTuples;
        this.fieldsOverridingAccessors = fieldsOverridingAccessors;
        this.fieldsPurelyMixedInNotOverridingAccessor = fieldsPurelyMixedInNotOverridingAccessor;
    }

    private static List<AccessorTuple> getConcreteFieldAccessors(List<TMember> ownedAndMixedInConcreteMember, List<TMember> concreteInheritedMembers) {
        HashSet<TField> ownedAndMixedInFields = new HashSet<TField>();
        HashSet<TGetter> ownedAndMixedInGetters = new HashSet<TGetter>();
        HashMap<NameStaticPair, TSetter> ownedAndMixedInSetters = new HashMap<NameStaticPair, TSetter>();
        for (TMember m : ownedAndMixedInConcreteMember) {
            if (m instanceof TField) {
                ownedAndMixedInFields.add((TField)m);
                continue;
            }
            if (m instanceof TGetter) {
                ownedAndMixedInGetters.add((TGetter)m);
                continue;
            }
            if (!(m instanceof TSetter)) continue;
            ownedAndMixedInSetters.put(NameStaticPair.of((TMember)m), (TSetter)m);
        }
        HashMap<NameStaticPair, TGetter> inheritedGetters = new HashMap<NameStaticPair, TGetter>();
        HashMap<NameStaticPair, TSetter> inheritedSetters = new HashMap<NameStaticPair, TSetter>();
        for (TMember m : concreteInheritedMembers) {
            NameStaticPair nsp;
            if (m instanceof TGetter) {
                if (ownedAndMixedInGetters.contains(m)) continue;
                inheritedGetters.put(NameStaticPair.of((TMember)m), (TGetter)m);
                continue;
            }
            if (!(m instanceof TSetter) || ownedAndMixedInSetters.get(nsp = NameStaticPair.of((TMember)m)) == m) continue;
            inheritedSetters.put(nsp, (TSetter)m);
        }
        List<AccessorTuple> ownedOrMixedInAccessorTouples = ConcreteMembersOrderedForTranspiler.mapToAccessorTuples(ownedAndMixedInGetters, ownedAndMixedInSetters, ownedAndMixedInFields, inheritedGetters, inheritedSetters);
        return ownedOrMixedInAccessorTouples;
    }

    private static List<AccessorTuple> mapToAccessorTuples(Iterable<TGetter> getters, Map<NameStaticPair, TSetter> io_setters, Iterable<TField> fields, Map<NameStaticPair, TGetter> io_inheritedGetters, Map<NameStaticPair, TSetter> io_inheritedSetters) {
        NameStaticPair nsp;
        AccessorTuple tuple;
        ArrayList<AccessorTuple> tuples = new ArrayList<AccessorTuple>();
        for (TGetter getter : getters) {
            tuple = new AccessorTuple(getter.getName(), getter.isStatic());
            tuple.setGetter(getter);
            nsp = NameStaticPair.of((TMember)getter);
            tuple.setSetter(io_setters.remove(nsp));
            if (tuple.getSetter() == null) {
                tuple.setInheritedSetter(io_inheritedSetters.remove(nsp));
            }
            tuples.add(tuple);
        }
        for (TSetter setter : io_setters.values()) {
            tuple = new AccessorTuple(setter.getName(), setter.isStatic());
            nsp = NameStaticPair.of((TMember)setter);
            tuple.setSetter(setter);
            tuple.setInheritedGetter(io_inheritedGetters.remove(nsp));
            tuples.add(tuple);
        }
        for (TField field : fields) {
            NameStaticPair nsp2 = NameStaticPair.of((TMember)field);
            io_inheritedSetters.remove(nsp2);
            io_inheritedGetters.remove(nsp2);
        }
        for (TSetter inhSetter : io_inheritedSetters.values()) {
            TGetter inhGetter = io_inheritedGetters.remove(NameStaticPair.of((TMember)inhSetter));
            if (inhGetter == null || inhSetter.getContainingType() == inhGetter.getContainingType() || !(inhSetter.getContainingType() instanceof TInterface) && !(inhGetter.getContainingType() instanceof TInterface)) continue;
            AccessorTuple tuple2 = new AccessorTuple(inhSetter.getName(), inhSetter.isStatic());
            tuple2.setInheritedGetter(inhGetter);
            tuple2.setInheritedSetter(inhSetter);
            tuples.add(tuple2);
        }
        return tuples;
    }

    private static MemberList<TField> getFieldsOverridingAccessor(Iterable<TMember> ownedAndMixedInConcreteMember, List<TMember> concreteInheritedMembers) {
        MemberList ownedAndMixedInFields = new MemberList();
        for (TMember m : ownedAndMixedInConcreteMember) {
            if (!(m instanceof TField) || !concreteInheritedMembers.stream().anyMatch(it -> (it.isGetter() || it.isSetter()) && it.getName().equals(m.getName()))) continue;
            ownedAndMixedInFields.add((Object)((TField)m));
        }
        return ownedAndMixedInFields;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder("Concrete members, ordered:\nMembers: ");
        strb.append(this.ownedAndMixedInConcreteMembers.stream().map(m -> m.getName()).collect(Collectors.joining(";")));
        strb.append("\nAccessors: ");
        strb.append(this.concreteAccessorTuples.stream().map(at -> at.toString()).collect(Collectors.joining(";")));
        strb.append("\nFields: ");
        strb.append(this.fieldsOverridingAccessors.stream().map(f -> f.getName()).collect(Collectors.joining(";")));
        return strb.toString();
    }
}

