/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.xpect.XjmTestMethod;
import org.eclipse.xpect.runner.AbstractTestRunner;
import org.eclipse.xpect.runner.XpectFileRunner;
import org.eclipse.xpect.setup.ThisTestObject;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.StateContainer;
import org.junit.runner.Description;

public class TestRunner
extends AbstractTestRunner {
    private XjmTestMethod method;
    private final StateContainer state;

    public TestRunner(StateContainer state, XpectFileRunner uriRunner, XjmTestMethod method) {
        super(uriRunner);
        Preconditions.checkNotNull((Object)method);
        this.method = method;
        this.state = state;
    }

    @Creates
    public TestRunner create() {
        return this;
    }

    @Override
    public Description createDescription() {
        Class<?> javaClass = this.getFileRunner().getJavaTestClass();
        String name = this.method.getName();
        return Description.createTestDescription(javaClass, (String)name);
    }

    @Override
    public XjmTestMethod getMethod() {
        return this.method;
    }

    @Override
    public StateContainer getState() {
        return this.state;
    }

    @Override
    protected void runInternal() throws Throwable {
        Object test = this.state.get(Object.class, ThisTestObject.class).get();
        try {
            this.method.getJavaMethod().invoke(test, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

