/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.versioning;

import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.n4idl.versioning.VersionHelper;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.VersionedFunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.VersionedParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.VersionedParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.VersionedReference;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;

public class N4IDLVersionResolver {
    @Inject
    private VersionHelper versionHelper;

    public <T extends TypeArgument, S> T resolveVersion(T typeRef, S versionedReference) {
        if (versionedReference instanceof VersionedReference) {
            return this.resolveVersion(typeRef, (VersionedReference)versionedReference);
        }
        return typeRef;
    }

    private <T extends TypeArgument> T resolveVersion(T typeRef, VersionedReference versionedReference) {
        boolean _hasRequestedVersion = versionedReference.hasRequestedVersion();
        if (_hasRequestedVersion) {
            return this.resolveVersion(typeRef, versionedReference.getRequestedVersionOrZero());
        }
        return typeRef;
    }

    public <T extends TypeArgument> T resolveVersion(T typeArg, int contextVersion) {
        boolean _hasDeclaredVersion;
        boolean _hasRequestedVersion;
        ComposedTypeRef _xblockexpression = null;
        if (contextVersion == 0) {
            return typeArg;
        }
        ComposedTypeRef _switchResult = null;
        boolean _matched = false;
        if (typeArg instanceof VersionedReference && (_hasRequestedVersion = ((VersionedReference)typeArg).hasRequestedVersion())) {
            _matched = true;
            _switchResult = (ComposedTypeRef)typeArg;
        }
        if (!_matched && typeArg instanceof VersionedElement && (_hasDeclaredVersion = ((VersionedElement)typeArg).hasDeclaredVersion())) {
            _matched = true;
            _switchResult = (ComposedTypeRef)typeArg;
        }
        if (!_matched && typeArg instanceof ComposedTypeRef) {
            ComposedTypeRef _resolveVersionOfComposedTypeRef;
            _matched = true;
            _switchResult = _resolveVersionOfComposedTypeRef = this.resolveVersionOfComposedTypeRef((ComposedTypeRef)typeArg, contextVersion);
        }
        if (!_matched && typeArg instanceof TypeTypeRef) {
            _matched = true;
            TypeTypeRef _resolveVersionOfTypeTypeRef = this.resolveVersionOfTypeTypeRef((TypeTypeRef)typeArg, contextVersion);
            _switchResult = _resolveVersionOfTypeTypeRef;
        }
        if (!_matched && typeArg instanceof FunctionTypeRef) {
            _matched = true;
            FunctionTypeRef _resolveVersionOfFunctionTypeRef = this.resolveVersionOfFunctionTypeRef((FunctionTypeRef)typeArg, contextVersion);
            _switchResult = _resolveVersionOfFunctionTypeRef;
        }
        if (!_matched && typeArg instanceof FunctionTypeExpression) {
            _matched = true;
            FunctionTypeExpression _resolveVersionOfFunctionTypeExpression = this.resolveVersionOfFunctionTypeExpression((FunctionTypeExpression)typeArg, contextVersion);
            _switchResult = _resolveVersionOfFunctionTypeExpression;
        }
        if (!_matched && typeArg instanceof ParameterizedTypeRef) {
            _matched = true;
            ParameterizedTypeRef _resolveVersionOfParameterizedTypeRef = this.resolveVersionOfParameterizedTypeRef((ParameterizedTypeRef)typeArg, contextVersion);
            _switchResult = _resolveVersionOfParameterizedTypeRef;
        }
        if (!_matched) {
            _switchResult = (ComposedTypeRef)typeArg;
        }
        _xblockexpression = _switchResult;
        return (T)_xblockexpression;
    }

    private ComposedTypeRef resolveVersionOfComposedTypeRef(ComposedTypeRef typeRef, int contextVersion) {
        ComposedTypeRef composedTypeRefWithVersion = (ComposedTypeRef)TypeUtils.copy((EObject)typeRef);
        this.resolveTypeArguments((List)composedTypeRefWithVersion.getTypeArgs(), contextVersion);
        return composedTypeRefWithVersion;
    }

    private TypeTypeRef resolveVersionOfTypeTypeRef(TypeTypeRef typeRef, int contextVersion) {
        TypeTypeRef typeTypeRefWithVersion = (TypeTypeRef)TypeUtils.copy((EObject)typeRef);
        typeTypeRefWithVersion.setTypeArg(this.resolveVersion(typeTypeRefWithVersion.getTypeArg(), contextVersion));
        return typeTypeRefWithVersion;
    }

    private FunctionTypeRef resolveVersionOfFunctionTypeRef(FunctionTypeRef typeRef, int contextVersion) {
        ContainerType container;
        Type _declaredType = typeRef.getDeclaredType();
        TFunction function = (TFunction)_declaredType;
        if (function instanceof TMethod && (container = ((TMethod)function).getContainingType()) instanceof TClassifier) {
            VersionedParameterizedTypeRef _copyParameterizedTypeRef = this.copyParameterizedTypeRef((ParameterizedTypeRef)typeRef, contextVersion);
            VersionedFunctionTypeRef functionTypeRefWithVersion = (VersionedFunctionTypeRef)_copyParameterizedTypeRef;
            functionTypeRefWithVersion.setDeclaredType((Type)this.versionHelper.findMemberWithVersion((TMethod)function, contextVersion));
            return functionTypeRefWithVersion;
        }
        return null;
    }

    private FunctionTypeExpression resolveVersionOfFunctionTypeExpression(FunctionTypeExpression typeRef, int contextVersion) {
        FunctionTypeExpression typeRefWithVersion = (FunctionTypeExpression)TypeUtils.copy((EObject)typeRef);
        typeRefWithVersion.setReturnTypeRef(this.resolveVersion((TypeArgument)typeRefWithVersion.getReturnTypeRef(), contextVersion));
        typeRefWithVersion.setDeclaredThisType(this.resolveVersion((TypeArgument)typeRefWithVersion.getDeclaredThisType(), contextVersion));
        this.resolveFormalParameters((List<TFormalParameter>)typeRefWithVersion.getFpars(), contextVersion);
        this.resolveTypeArguments((List)typeRefWithVersion.getUnboundTypeVarsUpperBounds(), contextVersion);
        return typeRefWithVersion;
    }

    private ParameterizedTypeRef resolveVersionOfParameterizedTypeRef(ParameterizedTypeRef typeRef, int contextVersion) {
        VersionedParameterizedTypeRef propTypeRefWithVersion = this.copyParameterizedTypeRef(typeRef, contextVersion);
        Type declaredType = typeRef.getDeclaredType();
        if (declaredType instanceof TClassifier) {
            propTypeRefWithVersion.setDeclaredType((Type)this.versionHelper.findTypeWithVersion((TClassifier)declaredType, contextVersion));
        }
        this.resolveTypeArguments((List)propTypeRefWithVersion.getTypeArgs(), contextVersion);
        return propTypeRefWithVersion;
    }

    private VersionedParameterizedTypeRef copyParameterizedTypeRef(ParameterizedTypeRef typeRef, int requestedVersion) {
        FunctionTypeRef _copy;
        VersionedFunctionTypeRef _switchResult = null;
        boolean _matched = false;
        if (typeRef instanceof FunctionTypeRef) {
            _matched = true;
            _copy = (FunctionTypeRef)TypeUtils.copy((EObject)((FunctionTypeRef)typeRef), (EClass)TypeRefsPackage.eINSTANCE.getVersionedFunctionTypeRef());
            _switchResult = (VersionedFunctionTypeRef)_copy;
        }
        if (!_matched && typeRef instanceof ParameterizedTypeRefStructural) {
            _matched = true;
            _copy = (ParameterizedTypeRefStructural)TypeUtils.copy((EObject)((ParameterizedTypeRefStructural)typeRef), (EClass)TypeRefsPackage.eINSTANCE.getVersionedParameterizedTypeRefStructural());
            _switchResult = (VersionedParameterizedTypeRefStructural)_copy;
        }
        if (!_matched) {
            _copy = (ParameterizedTypeRef)TypeUtils.copy((EObject)typeRef, (EClass)TypeRefsPackage.eINSTANCE.getVersionedParameterizedTypeRef());
            _switchResult = (VersionedParameterizedTypeRef)_copy;
        }
        VersionedFunctionTypeRef result = _switchResult;
        BigDecimal _bigDecimal = new BigDecimal(requestedVersion);
        result.setRequestedVersion(_bigDecimal);
        return result;
    }

    private <T extends TypeArgument> void resolveTypeArguments(List<T> typeArgs, int contextVersion) {
        ListIterator<T> i = typeArgs.listIterator();
        while (i.hasNext()) {
            TypeArgument current = (TypeArgument)i.next();
            if (current == null) continue;
            TypeArgument _resolveVersion = this.resolveVersion(current, contextVersion);
            i.set(_resolveVersion);
        }
    }

    private void resolveFormalParameters(List<TFormalParameter> parameters, int contextVersion) {
        ListIterator<TFormalParameter> i = parameters.listIterator();
        while (i.hasNext()) {
            TFormalParameter par = i.next();
            par.setTypeRef(this.resolveVersion((TypeArgument)par.getTypeRef(), contextVersion));
        }
    }
}

