/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetImpl;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.xtext.util.Arrays;

final class WorkingSetAdapter
extends ResourceMapping
implements IWorkingSet,
WorkingSet {
    private final WorkingSet delegate;
    private final Supplier<ImageDescriptor> imageDescriptorSupplier;

    WorkingSetAdapter(WorkingSet delegate) {
        this.delegate = delegate;
        this.imageDescriptorSupplier = Suppliers.memoize(() -> {
            Image image = (Image)this.delegate.getWorkingSetManager().getImage().orNull();
            if (image != null) {
                return ImageDescriptor.createFromImage((Image)image);
            }
            return null;
        });
    }

    public String getFactoryId() {
        return null;
    }

    public void saveState(IMemento memento) {
        this.delegate.getWorkingSetManager().saveState((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return this.delegate.getAdapter(adapter);
    }

    @Override
    public WorkingSetManager getWorkingSetManager() {
        return this.delegate.getWorkingSetManager();
    }

    @Override
    public IAdaptable[] getElements() {
        return this.delegate.getElements();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    public ImageDescriptor getImage() {
        return this.getImageDescriptor();
    }

    public ImageDescriptor getImageDescriptor() {
        return (ImageDescriptor)this.imageDescriptorSupplier.get();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public void setElements(IAdaptable[] elements) {
    }

    public void setId(String id) {
    }

    public void setName(String name) {
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isVisible() {
        Object[] visibleWorkingSets = this.delegate.getWorkingSetManager().getWorkingSets();
        return Arrays.contains((Object[])visibleWorkingSets, (Object)this.delegate);
    }

    public String getLabel() {
        return this.getName();
    }

    public void setLabel(String label) {
    }

    public boolean isSelfUpdating() {
        return false;
    }

    public boolean isAggregateWorkingSet() {
        return false;
    }

    public boolean isEmpty() {
        return this.delegate.getElements().length == 0;
    }

    public IAdaptable[] adaptElements(IAdaptable[] objects) {
        ArrayList elements = Lists.newArrayList((Object[])this.getElements());
        elements.retainAll(Lists.newArrayList((Object[])objects));
        return (IAdaptable[])Iterables.toArray((Iterable)elements, IAdaptable.class);
    }

    public Object getModelObject() {
        return this;
    }

    public String getModelProviderId() {
        return null;
    }

    public IProject[] getProjects() {
        return (IProject[])Arrays2.filter((Object[])this.getElements(), IProject.class);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        return new ResourceTraversal[]{new ResourceTraversal((IResource[])this.getProjects(), 2, 0)};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getWorkingSetManager().getId() == null ? 0 : this.getWorkingSetManager().getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkingSetImpl)) {
            return false;
        }
        WorkingSetImpl other = (WorkingSetImpl)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        return !(this.getWorkingSetManager().getId() == null ? other.getWorkingSetManager().getId() != null : !this.getWorkingSetManager().getId().equals(other.getWorkingSetManager().getId()));
    }
}

