/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class AbstractHistoryCommandHandler
extends AbstractHandler {
    AbstractHistoryCommandHandler() {
    }

    protected IWorkbenchPart getPart(ExecutionEvent event) throws ExecutionException {
        return HandlerUtil.getActivePartChecked((ExecutionEvent)event);
    }

    private Object getInput(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = this.getPart(event);
        if (!(part instanceof IHistoryView)) {
            throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_NoInputMessage);
        }
        return ((IHistoryView)part).getHistoryPage().getInput();
    }

    protected Repository getRepository(ExecutionEvent event) throws ExecutionException {
        Repository repository;
        IRepositoryCommit commit;
        IStructuredSelection selection = this.getSelection(event);
        if (!selection.isEmpty() && (commit = (IRepositoryCommit)Adapters.adapt((Object)selection.getFirstElement(), IRepositoryCommit.class)) != null) {
            return commit.getRepository();
        }
        Object input = this.getInput(event);
        if (input == null) {
            return null;
        }
        if (input instanceof HistoryPageInput) {
            return ((HistoryPageInput)input).getRepository();
        }
        if (input instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)input).getRepository();
        }
        Repository repo = (Repository)Adapters.adapt((Object)input, Repository.class);
        if (repo != null) {
            return repo;
        }
        IResource resource = AdapterUtils.adaptToAnyResource((Object)input);
        if (resource != null && (repository = ResourceUtil.getRepository((IResource)resource)) != null) {
            return repository;
        }
        throw new ExecutionException(UIText.AbstractHistoryCommanndHandler_CouldNotGetRepositoryMessage);
    }

    protected String getRepoRelativePath(Repository repo, File file) {
        Path workdirPath = new Path(repo.getWorkTree().getPath());
        IPath filePath = new Path(file.getPath()).setDevice(null);
        return filePath.removeFirstSegments(workdirPath.segmentCount()).toString();
    }

    protected List<RevTag> getRevTags(ExecutionEvent event) throws ExecutionException {
        Repository repo = this.getRepository(event);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk walk = new RevWalk(repo);){
                List revTags = repo.getRefDatabase().getRefsByPrefix("refs/tags/");
                ArrayList<RevTag> tags = new ArrayList<RevTag>();
                for (Ref ref : revTags) {
                    tags.add(walk.parseTag((AnyObjectId)repo.resolve(ref.getName())));
                }
                return tags;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected GitHistoryPage getPage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        if (window.getActivePage() == null) {
            return null;
        }
        IWorkbenchPart part = window.getActivePage().getActivePart();
        return this.getPageFromPart(part);
    }

    protected GitHistoryPage getPage(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = this.getPart(event);
        return this.getPageFromPart(part);
    }

    private GitHistoryPage getPageFromPart(IWorkbenchPart part) {
        if (!(part instanceof IHistoryView)) {
            return null;
        }
        IHistoryView view = (IHistoryView)part;
        IHistoryPage page = view.getHistoryPage();
        if (page instanceof GitHistoryPage) {
            return (GitHistoryPage)page;
        }
        return null;
    }

    protected IStructuredSelection getSelection(GitHistoryPage page) {
        if (page == null) {
            return StructuredSelection.EMPTY;
        }
        ISelection selection = page.getSelectionProvider().getSelection();
        return this.getStructuredSelection(selection);
    }

    protected IStructuredSelection getSelection(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        return this.getStructuredSelection(selection);
    }

    private IStructuredSelection getStructuredSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    protected ObjectId getSelectedCommitId(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        if (selection.size() != 1) {
            throw new ExecutionException(UIText.AbstractHistoryCommandHandler_ActionRequiresOneSelectedCommitMessage);
        }
        RevCommit commit = (RevCommit)Adapters.adapt((Object)selection.getFirstElement(), RevCommit.class);
        if (commit == null) {
            throw new ExecutionException(UIText.AbstractHistoryCommandHandler_ActionRequiresOneSelectedCommitMessage);
        }
        return commit.getId();
    }

    protected RevCommit getSelectedCommit(ExecutionEvent event) throws ExecutionException {
        List<RevCommit> commits = this.getSelectedCommits(event);
        if (commits.size() != 1) {
            throw new ExecutionException(UIText.AbstractHistoryCommandHandler_ActionRequiresOneSelectedCommitMessage);
        }
        return commits.get(0);
    }

    protected List<RevCommit> getSelectedCommits(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        if (repository == null) {
            return Collections.emptyList();
        }
        IStructuredSelection selection = this.getSelection(event);
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (RevWalk walk = new RevWalk(repository);){
                for (Object element : selection.toList()) {
                    RevCommit commit = (RevCommit)Adapters.adapt(element, RevCommit.class);
                    if (commit == null) continue;
                    RevCommit reparsed = walk.parseCommit((AnyObjectId)commit.getId());
                    commits.add(reparsed);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return commits;
    }

    protected List<RefNode> getRefNodes(ObjectId commit, Repository repo, String ... refPrefixes) {
        ArrayList<Ref> availableBranches = new ArrayList<Ref>();
        ArrayList<RefNode> nodes = new ArrayList<RefNode>();
        try {
            ArrayList branches = new ArrayList();
            String[] stringArray = refPrefixes;
            int n = refPrefixes.length;
            int n2 = 0;
            while (n2 < n) {
                String refPrefix = stringArray[n2];
                branches.addAll(repo.getRefDatabase().getRefsByPrefix(refPrefix));
                ++n2;
            }
            for (Ref branch : branches) {
                ObjectId objectId = branch.getLeaf().getObjectId();
                if (objectId == null || !objectId.equals((AnyObjectId)commit)) continue;
                availableBranches.add(branch);
            }
            RepositoryNode repoNode = new RepositoryNode(null, repo);
            for (Ref ref : availableBranches) {
                nodes.add(new RefNode(repoNode, repo, ref));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return nodes;
    }

    protected List<Ref> getBranchesOfCommit(IStructuredSelection selection, Repository repo, boolean hideCurrentBranch) throws IOException {
        String head = repo.getFullBranch();
        return this.getBranchesOfCommit(selection, head, hideCurrentBranch);
    }

    protected List<Ref> getBranchesOfCommit(IStructuredSelection selection) {
        return this.getBranchesOfCommit(selection, (String)null, false);
    }

    private List<Ref> getBranchesOfCommit(IStructuredSelection selection, String head, boolean hideCurrentBranch) {
        ArrayList<Ref> branchesOfCommit = new ArrayList<Ref>();
        if (selection.isEmpty()) {
            return branchesOfCommit;
        }
        RevCommit revCommit = (RevCommit)Adapters.adapt((Object)selection.getFirstElement(), RevCommit.class);
        if (!(revCommit instanceof PlotCommit)) {
            return branchesOfCommit;
        }
        PlotCommit commit = (PlotCommit)revCommit;
        int refCount = commit.getRefCount();
        int i = 0;
        while (i < refCount) {
            Ref ref = commit.getRef(i);
            String refName = ref.getName();
            if (!(hideCurrentBranch && head != null && refName.equals(head) || !refName.startsWith("refs/heads/") && !refName.startsWith("refs/remotes/"))) {
                branchesOfCommit.add(ref);
            }
            ++i;
        }
        return branchesOfCommit;
    }

    protected Repository getRepository(GitHistoryPage page) {
        if (page == null) {
            return null;
        }
        HistoryPageInput input = page.getInputInternal();
        if (input == null) {
            return null;
        }
        Repository repository = input.getRepository();
        return repository;
    }

    protected String getRenamedPath(String path, ObjectId commit) {
        return this.getPage().getRenamedPath(path, commit);
    }
}

