/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.internal.dnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropCommand;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropManager;
import org.eclipse.wst.common.ui.internal.dnd.ObjectTransfer;

public class ViewerDropAdapter
extends DropTargetAdapter {
    protected Viewer viewer;
    protected Collection source;
    protected DragAndDropCommand command;
    protected Object commandTarget;
    protected int hoverThreshold = 1500;
    protected long hoverStart = 0L;
    protected Widget previousItem;
    protected int originalOperation;
    protected DragAndDropCommandInformation dragAndDropCommandInformation;
    protected DragAndDropManager dragAndDropManager;

    public ViewerDropAdapter(Viewer viewer, DragAndDropManager dragAndDropManager) {
        this.viewer = viewer;
        this.dragAndDropManager = dragAndDropManager;
    }

    public void dragEnter(DropTargetEvent event) {
        this.originalOperation = event.detail;
        this.helper(event);
    }

    public void dragLeave(DropTargetEvent event) {
        if (this.command != null) {
            this.command = null;
            this.commandTarget = null;
        }
        this.previousItem = null;
        this.hoverStart = 0L;
        this.source = null;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.originalOperation = event.detail;
        this.helper(event);
    }

    public void dragOver(DropTargetEvent event) {
        this.helper(event);
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.dragAndDropCommandInformation != null) {
            this.command = this.dragAndDropCommandInformation.createCommand();
            this.command.execute();
            this.command = null;
            this.commandTarget = null;
            this.previousItem = null;
            this.hoverStart = 0L;
            this.source = null;
        }
    }

    protected void helper(DropTargetEvent event) {
        if (this.source == null) {
            this.source = this.getDragSource(event);
        } else if (event.currentDataType == null) {
            this.setCurrentDataType(event);
        }
        if (this.source == null) {
            event.detail = 0;
            event.feedback = 1;
        } else if (this.scrollIfNeeded(event)) {
            event.feedback = 1;
        } else {
            Object target;
            Object object = target = event.item == null ? null : event.item.getData();
            if (target instanceof Item) {
                target = ((Item)target).getData();
            }
            if (event.item != this.previousItem) {
                this.previousItem = event.item;
                this.hoverStart = event.time;
            } else if (target != null && (long)event.time - this.hoverStart > (long)this.hoverThreshold) {
                this.hover(target);
                this.hoverStart = Integer.MAX_VALUE;
            }
            boolean valid = false;
            if (this.command == null) {
                this.commandTarget = target;
                this.command = this.dragAndDropManager.createCommand(target, ViewerDropAdapter.getLocation(event), event.operations, event.detail, this.source);
                if (this.command != null) {
                    valid = this.command.canExecute();
                }
            } else {
                int operation;
                int n = operation = this.originalOperation != event.detail ? this.originalOperation : event.detail;
                if (target == this.commandTarget) {
                    float location = ViewerDropAdapter.getLocation(event);
                    this.dragAndDropCommandInformation = new DragAndDropCommandInformation(target, location, event.operations, operation, this.source);
                    this.command.reinitialize(target, location, event.operations, operation, this.source);
                    if (this.command != null) {
                        valid = this.command.canExecute();
                    }
                } else {
                    this.commandTarget = target;
                    this.dragAndDropCommandInformation = new DragAndDropCommandInformation(target, ViewerDropAdapter.getLocation(event), event.operations, operation, this.source);
                    this.command = this.dragAndDropCommandInformation.createCommand();
                    if (this.command != null) {
                        valid = this.command.canExecute();
                    }
                }
            }
            if (this.command != null) {
                event.detail = this.command.getOperation();
                event.feedback = this.command.getFeedback();
            } else if (valid) {
                event.feedback = 1;
            } else {
                event.detail = 0;
                event.feedback = 1;
            }
        }
    }

    protected void setCurrentDataType(DropTargetEvent event) {
        ObjectTransfer objectTransfer = ObjectTransfer.getInstance();
        TransferData[] dataTypes = event.dataTypes;
        int i = 0;
        while (i < dataTypes.length) {
            TransferData transferData = dataTypes[i];
            if (objectTransfer.isSupportedType(transferData)) {
                event.currentDataType = transferData;
            }
            ++i;
        }
    }

    protected Collection getDragSource(DropTargetEvent event) {
        ObjectTransfer objectTransfer = ObjectTransfer.getInstance();
        if (!objectTransfer.isSupportedType(event.currentDataType)) {
            this.setCurrentDataType(event);
            return null;
        }
        Object object = objectTransfer.nativeToJava(event.currentDataType);
        if (object == null) {
            return null;
        }
        return this.extractDragSource(object);
    }

    protected Collection extractDragSource(Object object) {
        if (object instanceof IStructuredSelection) {
            ArrayList result = new ArrayList();
            Iterator elements = ((IStructuredSelection)object).iterator();
            while (elements.hasNext()) {
                result.add(elements.next());
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public int getHoverThreshold() {
        return this.hoverThreshold;
    }

    public void setHoverThreshold(int hoverThreshold) {
        this.hoverThreshold = hoverThreshold;
    }

    protected void hover(Object target) {
        if (this.viewer instanceof AbstractTreeViewer) {
            ((AbstractTreeViewer)this.viewer).expandToLevel(target, 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean scrollIfNeeded(DropTargetEvent event) {
        block27: {
            block25: {
                block24: {
                    block26: {
                        result = false;
                        if (!(event.item instanceof TreeItem)) break block25;
                        treeItem = (TreeItem)event.item;
                        tree = treeItem.getParent();
                        point = tree.toControl(new Point(event.x, event.y));
                        bounds = tree.getClientArea();
                        scrollEpsilon = Math.min(treeItem.getBounds().height, bounds.height / 3);
                        scrollTreeItem = null;
                        if (point.y >= scrollEpsilon) break block26;
                        parent = treeItem.getParentItem();
                        children = parent == null ? tree.getItems() : parent.getItems();
                        i = 0;
                        while (i < children.length) {
                            if (children[i] == treeItem) {
                                if (i > 0) {
                                    scrollTreeItem = children[i - 1];
                                    while ((children = scrollTreeItem.getItems()) != null && children.length != 0 && scrollTreeItem.getExpanded()) {
                                        scrollTreeItem = children[children.length - 1];
                                    }
                                } else {
                                    scrollTreeItem = parent;
                                }
                                break block24;
                            }
                            ++i;
                        }
                        break block24;
                    }
                    if (bounds.height - point.y >= scrollEpsilon) break block24;
                    children = treeItem.getItems();
                    if (children == null || children.length == 0 || !treeItem.getExpanded()) ** GOTO lbl44
                    scrollTreeItem = children[0];
                    break block24;
lbl-1000:
                    // 1 sources

                    {
                        parent = treeItem.getParentItem();
                        children = parent == null ? tree.getItems() : parent.getItems();
                        i = 0;
                        while (i < children.length) {
                            if (children[i] == treeItem) {
                                if (++i >= children.length) break;
                                scrollTreeItem = children[i];
                                break;
                            }
                            ++i;
                        }
                        if (parent == null) break;
                        treeItem = parent;
lbl44:
                        // 2 sources

                        ** while (scrollTreeItem == null)
                    }
                }
                if (scrollTreeItem != null) {
                    if (this.previousItem != null && (long)event.time - this.hoverStart > 200L) {
                        verticalScrollBar = tree.getVerticalBar();
                        if (verticalScrollBar != null) {
                            before = verticalScrollBar.getSelection();
                            tree.showItem(scrollTreeItem);
                            this.previousItem = null;
                            result = before != verticalScrollBar.getSelection();
                        }
                    } else if (event.item != this.previousItem) {
                        this.previousItem = event.item;
                        this.hoverStart = event.time;
                    }
                }
                break block27;
            }
            if (event.item instanceof TableItem) {
                tableItem = (TableItem)event.item;
                table = tableItem.getParent();
                point = table.toControl(new Point(event.x, event.y));
                bounds = table.getClientArea();
                if (table.getHeaderVisible()) {
                    offset = table.getItemHeight();
                    bounds.y += offset;
                    bounds.height -= offset;
                    point.y -= offset;
                }
                index = table.indexOf(tableItem);
                scrollEpsilon = Math.min(tableItem.getBounds((int)0).height, bounds.height / 3);
                scrollTableItem = null;
                if (point.y < scrollEpsilon) {
                    if (index > 0) {
                        scrollTableItem = table.getItems()[index - 1];
                    }
                } else if (bounds.height - point.y < scrollEpsilon && index + 1 < table.getItems().length) {
                    scrollTableItem = table.getItems()[index + 1];
                }
                if (scrollTableItem != null) {
                    if (this.previousItem != null && (long)event.time - this.hoverStart > 200L) {
                        verticalScrollBar = table.getVerticalBar();
                        if (verticalScrollBar != null) {
                            before = verticalScrollBar.getSelection();
                            table.showItem(scrollTableItem);
                            this.previousItem = null;
                            result = before != verticalScrollBar.getSelection();
                        }
                    } else if (event.item != this.previousItem) {
                        this.previousItem = event.item;
                        this.hoverStart = event.time;
                    }
                }
            }
        }
        return result;
    }

    protected static float getLocation(DropTargetEvent event) {
        if (event.item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)event.item;
            Tree control = treeItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = treeItem.getBounds();
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        if (event.item instanceof TableItem) {
            TableItem tableItem = (TableItem)event.item;
            Table control = tableItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = tableItem.getBounds(0);
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        return 0.0f;
    }

    protected class DragAndDropCommandInformation {
        protected Object target;
        protected float location;
        protected int operations;
        protected int operation;
        protected Collection source;

        public DragAndDropCommandInformation(Object target, float location, int operations, int operation, Collection source) {
            this.target = target;
            this.location = location;
            this.operations = operations;
            this.operation = operation;
            this.source = new ArrayList(source);
        }

        public DragAndDropCommand createCommand() {
            return ViewerDropAdapter.this.dragAndDropManager.createCommand(this.target, this.location, this.operations, this.operation, this.source);
        }
    }
}

