/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc;

import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.FullMemberReference;

public class JSDocCompletionHint {
    public static final JSDocCompletionHint NO_COMPLETION = new JSDocCompletionHint(CompletionKind.NOCOMPLETION, "", null);
    public final CompletionKind kind;
    public final String prefix;
    public final ContentNode nodeToBeCompleted;

    public JSDocCompletionHint(CompletionKind kind, String prefix, ContentNode nodeToBeCompleted) {
        this.kind = kind;
        this.prefix = prefix;
        this.nodeToBeCompleted = nodeToBeCompleted;
    }

    public String toString() {
        return (Object)((Object)this.kind) + ", prefix: '" + this.prefix + "'";
    }

    public FullMemberReference nodeAsFullMemberReference() {
        if (this.nodeToBeCompleted instanceof FullMemberReference) {
            return (FullMemberReference)this.nodeToBeCompleted;
        }
        return null;
    }

    private char lastChar() {
        if (this.prefix.length() > 0) {
            return this.prefix.charAt(this.prefix.length() - 1);
        }
        return '\u0000';
    }

    public boolean isModuleNameCompleted() {
        FullMemberReference ref = this.nodeAsFullMemberReference();
        if (ref != null && ref.moduleNameSet()) {
            if (this.lastChar() == '.') {
                return true;
            }
            return ref.typeNameSet();
        }
        return false;
    }

    public boolean isTypeNameCompleted(boolean allowSimpleTypeRefs) {
        FullMemberReference ref = this.nodeAsFullMemberReference();
        if (ref != null) {
            if (allowSimpleTypeRefs && ref.moduleNameSet() && !ref.getModuleName().contains("/")) {
                if (this.lastCharOneOf(".#")) {
                    return true;
                }
                return ref.typeNameSet();
            }
            if (ref.typeNameSet()) {
                if (this.lastCharOneOf(".#")) {
                    return true;
                }
                return ref.memberNameSet();
            }
        }
        return false;
    }

    private boolean lastCharOneOf(String chars) {
        return chars.indexOf(this.lastChar()) >= 0;
    }

    public boolean isSimpleTypeRef() {
        FullMemberReference ref = this.nodeAsFullMemberReference();
        if (ref != null) {
            return ref.moduleNameSet() && !ref.typeNameSet();
        }
        return false;
    }

    public boolean isTypeModelRef() {
        return (this.kind == CompletionKind.MODULESPEC || this.kind == CompletionKind.FQTYPE || this.kind == CompletionKind.FQMEMBER) && this.nodeAsFullMemberReference() != null;
    }

    public static enum CompletionKind {
        NOCOMPLETION,
        INLINETAGS,
        TEMPLATES,
        MODULESPEC,
        FQTYPE,
        FQMEMBER;

    }
}

