/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.scoping;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xpect.Assignment;
import org.eclipse.xpect.Component;
import org.eclipse.xpect.XjmMethod;
import org.eclipse.xpect.XjmTest;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.XpectPackage;
import org.eclipse.xpect.XpectTest;
import org.eclipse.xpect.scoping.ComponentUtil;
import org.eclipse.xpect.scoping.SimpleTypeScope;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.Strings;

public class XpectScopeProvider
extends AbstractScopeProvider {
    @Inject
    @Named(value="org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate")
    private IScopeProvider delegate;
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;

    private Set<JvmDeclaredType> getAssignableTypes(EObject context) {
        EObject current = context;
        XpectJavaModel xjm = ((XpectFile)EcoreUtil2.getContainerOfType((EObject)context, XpectFile.class)).getJavaModel();
        ComponentUtil util = new ComponentUtil(xjm);
        while (current != null) {
            if (current instanceof Assignment) {
                return util.getValidTypes((Assignment)current);
            }
            if (current instanceof XpectTest) {
                return util.getValidRootTypes();
            }
            current = current.eContainer();
        }
        return Collections.emptySet();
    }

    private String getAssignmentTargetFeatureName(JvmFeature feature) {
        String name;
        String fullname;
        JvmOperation op;
        if (feature instanceof JvmOperation && (op = (JvmOperation)feature).getParameters().size() == 1 && ((fullname = op.getSimpleName()).startsWith("set") || fullname.startsWith("add")) && (name = Strings.toFirstLower((String)fullname.substring(3))).length() > 0) {
            return name;
        }
        return null;
    }

    public IScope getScope(EObject context, EReference reference) {
        if (reference == XpectPackage.Literals.XPECT_TEST__DECLARED_SUITE) {
            return this.getScopeForTestClassOrSuite((XpectFile)EcoreUtil2.getContainerOfType((EObject)context, XpectFile.class));
        }
        if (reference == XpectPackage.Literals.XPECT_INVOCATION__METHOD) {
            return this.getScopeForXpectInvocationTestMethod((XpectFile)EcoreUtil2.getContainerOfType((EObject)context, XpectFile.class));
        }
        if (reference == XpectPackage.Literals.ASSIGNMENT__DECLARED_TARGET) {
            return this.getScopeForAssignmentTarget((Component)EcoreUtil2.getContainerOfType((EObject)context, Component.class));
        }
        if (reference == XpectPackage.Literals.COMPONENT__COMPONENT_CLASS) {
            return this.getScopeForComponentClass(context, reference);
        }
        return this.delegate.getScope(context, reference);
    }

    private IScope getScopeForAssignmentTarget(Component owner) {
        JvmDeclaredType type;
        ArrayList descs = Lists.newArrayList();
        if (owner != null && (type = owner.getComponentClass()) != null && !type.eIsProxy()) {
            for (JvmFeature feature : type.getAllFeatures()) {
                String name = this.getAssignmentTargetFeatureName(feature);
                if (name == null) continue;
                descs.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)name), (EObject)feature));
            }
        }
        return new SimpleScope((Iterable)descs);
    }

    private IScope getScopeForComponentClass(EObject context, EReference reference) {
        Set<JvmDeclaredType> types = this.getAssignableTypes(context);
        ArrayList descriptions = Lists.newArrayList();
        for (JvmDeclaredType type : types) {
            descriptions.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)type.getSimpleName()), (EObject)type));
        }
        SimpleTypeScope typeScope = new SimpleTypeScope(this.typeProviderFactory.findOrCreateTypeProvider(context.eResource().getResourceSet()));
        return new SimpleScope((IScope)typeScope, (Iterable)descriptions);
    }

    private IScope getScopeForTestClassOrSuite(XpectFile xpectFile) {
        ResourceSet resourceSet = xpectFile.eResource().getResourceSet();
        return new SimpleTypeScope(this.typeProviderFactory.findOrCreateTypeProvider(resourceSet));
    }

    private IScope getScopeForXpectInvocationTestMethod(XpectFile file) {
        XpectJavaModel model = file.getJavaModel();
        if (model == null || model.eIsProxy()) {
            return IScope.NULLSCOPE;
        }
        ArrayList descs = Lists.newArrayList();
        for (XjmTest op : model.getTests()) {
            for (XjmMethod method : op.getMethods()) {
                if (method == null) continue;
                descs.add(EObjectDescription.create((QualifiedName)QualifiedName.create((String)method.getName()), (EObject)method));
            }
        }
        return new SimpleScope((Iterable)descs);
    }
}

