/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.scoping.utils.CanLoadFromDescriptionHelper;
import org.eclipse.xtext.resource.ResourceSetContext;
import org.eclipse.xtext.ui.editor.IDirtyStateManager;
import org.eclipse.xtext.ui.editor.IDirtyStateManagerExtension;

@Singleton
public class EditorAwareCanLoadFromDescriptionHelper
extends CanLoadFromDescriptionHelper {
    private IDirtyStateManagerExtension dirtyStateManager = Collections::emptyList;

    @Inject
    private void setDirtyStateManager(IDirtyStateManager dirtyStateManager) {
        if (dirtyStateManager instanceof IDirtyStateManagerExtension) {
            this.dirtyStateManager = (IDirtyStateManagerExtension)dirtyStateManager;
        }
    }

    public boolean mustLoadFromSource(URI resourceURI, ResourceSet resourceSet) {
        if (super.mustLoadFromSource(resourceURI, resourceSet)) {
            return true;
        }
        ResourceSetContext context = ResourceSetContext.get((Notifier)resourceSet);
        if (!context.isBuilder()) {
            ImmutableSet openEditors = ImmutableSet.copyOf((Collection)this.dirtyStateManager.getDirtyResourceURIs());
            return this.dependsOnAny(resourceURI, (Set)openEditors, this.getIndex(resourceSet), false);
        }
        return false;
    }
}

