/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.scoping;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.MigrationContextVariable;
import org.eclipse.n4js.n4idl.migrations.MigrationLocator;
import org.eclipse.n4js.n4idl.versioning.MigrationUtils;
import org.eclipse.n4js.resource.N4JSEObjectDescription;
import org.eclipse.n4js.scoping.utils.IssueCodeBasedEObjectDescription;
import org.eclipse.n4js.scoping.utils.UnresolvableObjectDescription;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.versions.MigratableUtils;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SingletonScope;

public class MigrationScopeHelper {
    @Inject
    private MigrationLocator migrationLocator;

    public IScope migrationsScope(List<Argument> arguments, EObject context) {
        Optional<TMigration> contextMigration = MigrationUtils.getTMigrationOf(context);
        if (!contextMigration.isPresent()) {
            return IScope.NULLSCOPE;
        }
        TMigration contextTMigration = contextMigration.get();
        List<TMigration> targetMigrations = this.migrationLocator.findMigration(arguments, contextTMigration);
        if (targetMigrations.isEmpty()) {
            return new SingletonScope((IEObjectDescription)new UnresolvableObjectDescription(QualifiedName.create((String)"migrate")), IScope.NULLSCOPE);
        }
        Object migrationDescription = N4JSEObjectDescription.create(QualifiedName.create((String)"migrate"), (EObject)targetMigrations.get(0));
        if (targetMigrations.size() > 1) {
            migrationDescription = new IssueCodeBasedEObjectDescription((IEObjectDescription)migrationDescription, IssueCodes.getMessageForIDL_MIGRATE_CALL_AMBIGUOUS(MigratableUtils.getMigrationCandidatesList(targetMigrations)), "IDL_MIGRATE_CALL_AMBIGUOUS", Severity.WARNING);
        }
        return new SingletonScope(migrationDescription, IScope.NULLSCOPE);
    }

    public IScope migrationContextAwareScope(FunctionDeclaration declaration, IScope parent) {
        MigrationContextVariable migrationContextVariable = declaration.getMigrationContextVariable();
        return new SingletonScope(N4JSEObjectDescription.create(QualifiedName.create((String)migrationContextVariable.getName()), (EObject)migrationContextVariable), parent);
    }
}

