/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.n4js.transpiler.sourcemap.LineMappings;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntryIterator;
import org.eclipse.n4js.transpiler.sourcemap.SourceMapParser;

public class SourceMap {
    public String version = "3";
    public String file = "";
    public String sourceRoot = "";
    public final List<String> sources = new ArrayList<String>();
    public final List<String> names = new ArrayList<String>();
    final List<LineMappings.ByGen> genMappings = new ArrayList<LineMappings.ByGen>();
    final List<List<LineMappings.BySrc>> srcMappings = new ArrayList<List<LineMappings.BySrc>>();
    Path resolvedMapFile = null;
    Path resolvedFile = null;
    List<Path> resolvedSources = Collections.emptyList();

    public static SourceMap parse(CharSequence s) {
        return SourceMapParser.parse(s);
    }

    public static SourceMap loadAndResolve(Path sourceMapPath) throws IOException {
        InputStream inStream = Files.newInputStream(sourceMapPath, new OpenOption[0]);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader reader = new InputStreamReader(inStream, Charsets.UTF_8);){
            SourceMap sourceMap = SourceMap.parse(CharStreams.toString((Readable)reader));
            sourceMap.resolvedMapFile = sourceMapPath;
            Path sourceMapFolder = sourceMapPath.getParent();
            sourceMap.resolvedFile = sourceMapFolder.resolve(sourceMap.file);
            ArrayList<Path> list = new ArrayList<Path>(sourceMap.sources.size());
            for (String src : sourceMap.sources) {
                Path path = sourceMapFolder.resolve(src);
                list.add(path);
            }
            sourceMap.resolvedSources = Collections.unmodifiableList(list);
            return sourceMap;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addMappig(MappingEntry entry) {
        LineMappings.ByGen lineMapping = this.getOrCreateSrcLineMapping(entry.genLine);
        lineMapping.add(entry);
        LineMappings.BySrc lineSrcMapping = this.getOrCreateSrcLineMapping(entry.srcIndex, entry.srcLine);
        lineSrcMapping.add(entry);
    }

    private LineMappings.ByGen getOrCreateSrcLineMapping(int outputLine) {
        return this.getOrCreateLineMapping(this.genMappings, outputLine, LineMappings.ByGen::new);
    }

    private LineMappings.BySrc getOrCreateSrcLineMapping(int srcIndex, int srcLine) {
        List<LineMappings.BySrc> mappings = null;
        if (srcIndex < this.srcMappings.size()) {
            mappings = this.srcMappings.get(srcIndex);
            if (mappings == null) {
                mappings = new ArrayList<LineMappings.BySrc>();
                this.srcMappings.set(srcIndex, mappings);
            }
        } else {
            int i = this.srcMappings.size();
            while (i < srcIndex) {
                this.srcMappings.add(null);
                ++i;
            }
            mappings = new ArrayList<LineMappings.BySrc>();
            this.srcMappings.add(mappings);
        }
        return this.getOrCreateLineMapping(mappings, srcLine, LineMappings.BySrc::new);
    }

    private <T extends TreeSet<MappingEntry>> T getOrCreateLineMapping(List<T> mappings, int line, Supplier<T> ctor) {
        TreeSet lineMappings;
        if (line < mappings.size()) {
            lineMappings = (TreeSet)mappings.get(line);
            if (lineMappings == null) {
                lineMappings = (TreeSet)ctor.get();
                mappings.set(line, lineMappings);
            }
        } else {
            int i = mappings.size();
            while (i < line) {
                mappings.add(null);
                ++i;
            }
            lineMappings = (TreeSet)ctor.get();
            mappings.add(lineMappings);
        }
        return (T)lineMappings;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        try {
            this.toString(strb);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return strb.toString();
    }

    public void toString(Appendable out) throws IOException {
        this.writeBeginning(out);
        this.writeMappings(out);
        this.writeClosing(out);
    }

    private void appendProp(Appendable out, String propName) throws IOException {
        out.append("\n\t\"");
        out.append(propName);
        out.append("\": ");
    }

    private void writeBeginning(Appendable out) throws IOException {
        out.append("{");
        this.appendProp(out, "version");
        out.append(this.version);
        out.append(",");
        this.appendProp(out, "file");
        out.append("\"");
        out.append(this.esc(this.file));
        out.append("\",");
        this.appendProp(out, "sourceRoot");
        out.append("\"");
        out.append(this.esc(this.sourceRoot));
        out.append("\",");
        this.appendProp(out, "sources");
        out.append("[");
        out.append(this.sources.stream().map(source -> "\"" + this.esc((String)source) + "\"").collect(Collectors.joining(",")));
        out.append("],");
        this.appendProp(out, "names");
        out.append("[");
        out.append(this.names.stream().map(name -> "\"" + this.esc((String)name) + "\"").collect(Collectors.joining(",")));
        out.append("],");
        this.appendProp(out, "mappings");
        out.append("\"");
    }

    private CharSequence esc(String name) {
        StringBuilder strb = new StringBuilder(name.length() + 2);
        int length = name.length();
        int i = 0;
        while (i < length) {
            char c = name.charAt(i);
            if (c == '\"') {
                strb.append("\\");
            }
            strb.append(c);
            ++i;
        }
        return strb;
    }

    private void writeClosing(Appendable out) throws IOException {
        out.append("\"\n}");
    }

    private void writeMappings(Appendable out) throws IOException {
        boolean bFirst = true;
        MappingEntry.PreviousEntry prev = new MappingEntry.PreviousEntry();
        for (LineMappings.ByGen lineMappings : this.genMappings) {
            if (bFirst) {
                bFirst = false;
            } else {
                out.append(';');
            }
            if (lineMappings == null) continue;
            Iterator iter = lineMappings.iterator();
            MappingEntry entry = (MappingEntry)iter.next();
            String segment = entry.toBase64VLQRelative(prev);
            entry.updatePrev(prev);
            out.append(segment);
            while (iter.hasNext()) {
                out.append(',');
                entry = (MappingEntry)iter.next();
                segment = entry.toBase64VLQRelative(prev);
                entry.updatePrev(prev);
                out.append(segment);
            }
            prev.genColumn = 0;
        }
    }

    public Path getResolvedMapFile() {
        return this.resolvedMapFile;
    }

    public Path getResolvedFile() {
        return this.resolvedFile;
    }

    public List<Path> getResolvedSources() {
        return this.resolvedSources;
    }

    public MappingEntry findMappingForGenPosition(int genLine, int genColumns) {
        if (genLine < 0 || genColumns < 0 || genLine >= this.genMappings.size()) {
            return null;
        }
        LineMappings.ByGen lineMappings = this.genMappings.get(genLine);
        if (lineMappings == null) {
            return null;
        }
        MappingEntry entry = lineMappings.findEntryByColumn(genColumns);
        return entry;
    }

    public MappingEntry findMappingForSrcPosition(int sourceIndex, int sourceLine, int sourceColumn) {
        if (sourceColumn < 0 || sourceLine < 0 || sourceIndex < 0 || sourceIndex >= this.srcMappings.size()) {
            return null;
        }
        List<LineMappings.BySrc> mappings = this.srcMappings.get(sourceIndex);
        if (sourceLine >= mappings.size()) {
            return null;
        }
        LineMappings.BySrc lineMappings = mappings.get(sourceLine);
        if (lineMappings == null) {
            return null;
        }
        MappingEntry entry = lineMappings.findEntryByColumn(sourceColumn);
        return entry;
    }

    public int computeLengthGen(MappingEntry entry) {
        if (entry.nameIndex >= 0 && entry.nameIndex < this.names.size()) {
            return this.names.get(entry.nameIndex).length();
        }
        MappingEntry next = this.nextEntryForTarget(entry, entry.genLine, this.genMappings);
        if (next == null) {
            return -1;
        }
        return next.genColumn - entry.genColumn;
    }

    public int computeLengthSrc(MappingEntry entry) {
        MappingEntry next = this.nextEntryForTarget(entry, entry.srcLine, this.srcMappings.get(entry.srcIndex));
        if (next == null) {
            return -1;
        }
        return next.srcColumn - entry.srcColumn;
    }

    private MappingEntry nextEntryForTarget(MappingEntry entry, int targetLine, List<? extends LineMappings> targetMappings) {
        if (entry == null || targetLine < 0 || targetLine >= targetMappings.size()) {
            return null;
        }
        LineMappings lineMappings = targetMappings.get(targetLine);
        boolean entryFound = false;
        MappingEntry next = null;
        for (MappingEntry e : lineMappings) {
            if (e == entry) {
                entryFound = true;
                continue;
            }
            if (!entryFound) continue;
            next = e;
            break;
        }
        return next;
    }

    public Iterable<MappingEntry> getGenMappings() {
        return new Iterable<MappingEntry>(){

            @Override
            public Iterator<MappingEntry> iterator() {
                return new MappingEntryIterator(SourceMap.this.genMappings.iterator());
            }
        };
    }
}

