/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.osgi.framework.BundleContext;

public class AntCoreUtil {
    private static BundleContext fgContext = null;

    public static void setBundleContext(BundleContext context) {
        fgContext = context;
    }

    public static BundleContext getBundleContext() {
        return fgContext;
    }

    public static ArrayList<String> getArrayList(String[] args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(args.length);
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    public static String getArgument(List<String> commands, String param) {
        if (commands == null) {
            return null;
        }
        int index = commands.indexOf(param);
        if (index == -1) {
            return null;
        }
        commands.remove(index);
        if (index == commands.size()) {
            return "";
        }
        String command = commands.get(index);
        if (command.startsWith("-")) {
            return "";
        }
        commands.remove(index);
        return command;
    }

    public static void processMinusDProperties(List<String> commands, Map<String, String> userProperties) {
        Iterator<String> iter = commands.iterator();
        while (iter.hasNext()) {
            String arg = iter.next();
            if (!arg.startsWith("-D")) continue;
            String name = arg.substring(2, arg.length());
            String value = null;
            int posEq = name.indexOf("=");
            if (posEq == 0) {
                value = name.substring(1);
                name = "";
            } else if (posEq > 0 && posEq != name.length() - 1) {
                value = name.substring(posEq + 1).trim();
                name = name.substring(0, posEq);
            }
            if (value == null) continue;
            userProperties.put(name, value);
            iter.remove();
        }
    }

    public static File getFileRelativeToBaseDir(String fileName, String base, String buildFileLocation) {
        Path path = new Path(fileName);
        if (!path.isAbsolute()) {
            if (base != null) {
                File baseDir = new File(base);
                path = new Path(baseDir.getAbsolutePath());
            } else {
                path = new Path(buildFileLocation);
                path = path.removeLastSegments(1);
            }
            path = path.addTrailingSeparator();
            path = path.append(fileName);
        }
        return path.toFile();
    }

    public static List<Properties> loadPropertyFiles(List<String> fileNames, String base, String buildFileLocation) throws IOException {
        ArrayList<Properties> allProperties = new ArrayList<Properties>(fileNames.size());
        int i = 0;
        while (i < fileNames.size()) {
            String filename = fileNames.get(i);
            File file = AntCoreUtil.getFileRelativeToBaseDir(filename, base, buildFileLocation);
            Properties props = new Properties();
            Throwable throwable = null;
            Object var9_10 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                props.load(fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                String value = props.getProperty(name);
                props.remove(name);
                IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    name = stringVariableManager.performStringSubstitution(name);
                    value = stringVariableManager.performStringSubstitution(value);
                }
                catch (CoreException e) {
                    AntCorePlugin.log(e);
                }
                props.setProperty(name, value);
            }
            allProperties.add(props);
            ++i;
        }
        return allProperties;
    }
}

