/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xpect.util.ClasspathUtil;
import org.eclipse.xpect.util.ResourceAccess;

public interface IBundleInfo {
    public List<URI> find(Context var1);

    public URI find(Context var1, String var2);

    public List<URI> find(Context var1, String var2, Predicate<String> var3, String ... var4);

    public URI getRootURI();

    public String getSymbolicName();

    public static class BundleInfo
    implements IBundleInfo {
        private ResourceAccess.ResourceInfo info;
        private final URI location;
        private final String symbolicName;

        public BundleInfo(String symbolicName, URI locationURI) {
            this.symbolicName = symbolicName;
            this.location = locationURI;
        }

        private ResourceAccess.ResourceInfo getInfo() {
            if (this.info == null) {
                this.info = ResourceAccess.create(this.location);
            }
            return this.info;
        }

        @Override
        public List<URI> find(Context context) {
            return this.getInfo().find(context);
        }

        @Override
        public URI find(Context context, String fileName) {
            return this.getInfo().find(context, fileName);
        }

        @Override
        public List<URI> find(Context context, String path, Predicate<String> matcher, String ... fileExtensions) {
            return this.getInfo().find(context, path, matcher, fileExtensions);
        }

        @Override
        public URI getRootURI() {
            return this.getInfo().getLocation();
        }

        @Override
        public String getSymbolicName() {
            return this.symbolicName;
        }

        public String toString() {
            return String.valueOf(this.symbolicName) + ": " + this.getInfo();
        }
    }

    public static enum Context {
        CLASSPATH,
        ROOT,
        SOURCE;

    }

    public static class Delegate
    implements Registry {
        private Registry delegate;

        @Override
        public Collection<String> getAllBundleNames() {
            return this.delegate.getAllBundleNames();
        }

        @Override
        public IBundleInfo getBundle(Class<?> clazz) {
            return this.delegate.getBundle(clazz);
        }

        @Override
        public IBundleInfo getBundle(String symbolicName) {
            return this.delegate.getBundle(symbolicName);
        }

        public Registry getDelegate() {
            return this.delegate;
        }

        public void setDelegate(Registry delegate) {
            this.delegate = delegate;
        }

        @Override
        public IBundleInfo getBundle(URI uri) {
            return this.delegate.getBundle(uri);
        }
    }

    public static interface Registry {
        public static final Registry INSTANCE = EcorePlugin.IS_ECLIPSE_RUNNING ? new Delegate() : new StandaloneBundleRegistry();

        public Collection<String> getAllBundleNames();

        public IBundleInfo getBundle(Class<?> var1);

        public IBundleInfo getBundle(URI var1);

        public IBundleInfo getBundle(String var1);
    }

    public static class StandaloneBundleRegistry
    implements Registry {
        public static final Logger LOG = Logger.getLogger(StandaloneBundleRegistry.class);
        private final Map<URI, IBundleInfo> locationToBundle;
        private final Map<String, IBundleInfo> symbolicNameToBundle = Maps.newLinkedHashMap();

        public static void main(String[] args) {
            System.out.println(new StandaloneBundleRegistry());
        }

        public StandaloneBundleRegistry() {
            this.locationToBundle = Maps.newLinkedHashMap();
            for (URL url : ClasspathUtil.findResources("META-INF/MANIFEST.MF")) {
                try {
                    String name = ClasspathUtil.getSymbolicName(url.openStream());
                    if (name == null) continue;
                    URI location = URI.createURI((String)url.toString()).trimSegments(2).appendSegment("");
                    BundleInfo info = this.createBundleInfo(name, location);
                    this.symbolicNameToBundle.put(name, info);
                    this.locationToBundle.put(location, info);
                }
                catch (Throwable e) {
                    LOG.error((Object)("can't open " + url), e);
                }
            }
        }

        private BundleInfo createBundleInfo(String name, URI location) {
            return new BundleInfo(name, location);
        }

        @Override
        public Collection<String> getAllBundleNames() {
            return this.symbolicNameToBundle.keySet();
        }

        @Override
        public IBundleInfo getBundle(Class<?> clazz) {
            URI bundleURI = this.getBundleURI(clazz);
            IBundleInfo info = this.locationToBundle.get(bundleURI);
            if (info != null) {
                return info;
            }
            info = this.createBundleInfo(null, bundleURI);
            this.locationToBundle.put(bundleURI, info);
            return info;
        }

        @Override
        public IBundleInfo getBundle(String symbolicName) {
            return this.symbolicNameToBundle.get(symbolicName);
        }

        private URI getBundleURI(Class<?> clazz) {
            Object[] segments = clazz.getName().split("\\.");
            String fileName = String.valueOf(Joiner.on((char)'/').join(segments)) + ".class";
            URL resource = clazz.getClassLoader().getResource(fileName);
            if ("jar".equals(resource.getProtocol())) {
                URI location = URI.createURI((String)resource.toString()).trimSegments(segments.length).appendSegment("");
                return location;
            }
            try {
                File classFile;
                File packageRootFolder = classFile = new File(resource.toURI());
                int i = 0;
                while (i < segments.length) {
                    if ((packageRootFolder = packageRootFolder.getParentFile()) == null) {
                        throw new RuntimeException("Could not determine package root for " + clazz);
                    }
                    ++i;
                }
                File current = packageRootFolder;
                while (current != null) {
                    if (new File(current, ".project").isFile()) {
                        return URI.createFileURI((String)current.toString()).appendSegment("");
                    }
                    current = current.getParentFile();
                }
                throw new RuntimeException("Could not find .project file in super-folder of " + packageRootFolder);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return Joiner.on((String)"\n").join(this.symbolicNameToBundle.values());
        }

        @Override
        public IBundleInfo getBundle(URI uri) {
            return this.createBundleInfo(null, uri);
        }
    }
}

