/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.organize.imports.DIUtility;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.im.ReferencingElementExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotationArgument;
import org.eclipse.n4js.ts.types.TAnnotationTypeRefArgument;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class DependencyInjectionTransformation
extends Transformation {
    @Inject
    private TypeAssistant typeAssistant;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4ClassDeclaration> _function = classDecl -> {
            SymbolTableEntryOriginal superClassSTE;
            Statement codeForDI;
            TClass tClass = this.getState().info.getOriginalDefinedType(classDecl);
            if (tClass != null && (codeForDI = this.generateCodeForDI(tClass, (N4ClassDeclaration)classDecl, (SymbolTableEntry)(superClassSTE = this.typeAssistant.getSuperClassSTE(classDecl)))) != null) {
                this.insertAfter(TranspilerUtils.orContainingExportDeclaration((EObject)classDecl), new EObject[]{codeForDI});
            }
        };
        this.collectNodes((EObject)this.getState().im, N4ClassDeclaration.class, false).forEach(_function);
    }

    private Statement generateCodeForDI(TClass it, N4ClassDeclaration classDecl, SymbolTableEntry superClassSTE) {
        Pair<String, Expression>[] propertiesForDI = this.createPropertiesForDI(it, classDecl, superClassSTE);
        boolean _isEmpty = ((List)Conversions.doWrapArray(propertiesForDI)).isEmpty();
        if (_isEmpty) {
            return null;
        }
        SymbolTableEntry classSTE = this.findSymbolTableEntryForElement((NamedElement)classDecl, true);
        SymbolTableEntryOriginal objectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), true);
        SymbolTableEntryOriginal definePropertySTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "defineProperty", false, true, true);
        SymbolTableEntryOriginal symbolObjectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.symbolObjectType((RuleEnvironment)this.getState().G), true);
        SymbolTableEntryOriginal forSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.symbolObjectType((RuleEnvironment)this.getState().G), "for", false, true, true);
        ObjectLiteral __ObjLit = TranspilerBuilderBlocks._ObjLit(propertiesForDI);
        Pair _mappedTo = Pair.of((Object)"value", (Object)__ObjLit);
        return TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)objectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{definePropertySTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)classSTE), TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)symbolObjectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{forSTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._StringLiteral((String)"org.eclipse.n4js/diInfo")}), TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo})}));
    }

    private Pair<String, Expression>[] createPropertiesForDI(TClass it, N4ClassDeclaration classDecl, SymbolTableEntry superClassSTE) {
        ArrayList result = CollectionLiterals.newArrayList();
        boolean _isBinder = DIUtility.isBinder((Type)it);
        if (_isBinder) {
            ArrayLiteral _generateBindingPairs = this.generateBindingPairs(it);
            Pair _mappedTo = Pair.of((Object)"bindings", (Object)_generateBindingPairs);
            result.add(_mappedTo);
            ArrayLiteral _generateMethodBindings = this.generateMethodBindings(it);
            Pair _mappedTo_1 = Pair.of((Object)"methodBindings", (Object)_generateMethodBindings);
            result.add(_mappedTo_1);
            Pair<String, Expression>[] _injectionPointsMetaInfo = this.injectionPointsMetaInfo(it, superClassSTE);
            Iterables.addAll((Collection)result, (Iterable)((Iterable)Conversions.doWrapArray(_injectionPointsMetaInfo)));
        } else {
            boolean _isDIComponent = DIUtility.isDIComponent((Type)it);
            if (_isDIComponent) {
                boolean _hasParentInjector = DIUtility.hasParentInjector((Type)it);
                if (_hasParentInjector) {
                    SymbolTableEntryOriginal parentDIC_STE = this.getSymbolTableEntryOriginal((IdentifiableElement)DIUtility.findParentDIC((Type)it), true);
                    ReferencingElementExpression_IM ___NSSafe_IdentRef = this.__NSSafe_IdentRef((SymbolTableEntry)parentDIC_STE);
                    Pair _mappedTo_2 = Pair.of((Object)"parent", (Object)___NSSafe_IdentRef);
                    result.add(_mappedTo_2);
                }
                ArrayLiteral _generateBinders = this.generateBinders(it);
                Pair _mappedTo_3 = Pair.of((Object)"binders", (Object)_generateBinders);
                result.add(_mappedTo_3);
                Pair<String, Expression>[] _injectionPointsMetaInfo_1 = this.injectionPointsMetaInfo(it, superClassSTE);
                Iterables.addAll((Collection)result, (Iterable)((Iterable)Conversions.doWrapArray(_injectionPointsMetaInfo_1)));
            } else {
                boolean _isInjectedClass = DIUtility.isInjectedClass((Type)it);
                if (_isInjectedClass) {
                    Pair<String, Expression>[] _injectionPointsMetaInfo_2 = this.injectionPointsMetaInfo(it, superClassSTE);
                    Iterables.addAll((Collection)result, (Iterable)((Iterable)Conversions.doWrapArray(_injectionPointsMetaInfo_2)));
                }
            }
        }
        return (Pair[])Conversions.unwrapArray((Object)result, Pair.class);
    }

    private Pair<String, Expression>[] injectionPointsMetaInfo(TClass it, SymbolTableEntry superClassSTE) {
        boolean _isEmpty;
        boolean _not;
        ArrayLiteral fieldInjectionValue = this.fieldInjection(it);
        ArrayList result = CollectionLiterals.newArrayList();
        boolean _isSingleton = DIUtility.isSingleton((Type)it);
        if (_isSingleton) {
            StringLiteral __StringLiteral = TranspilerBuilderBlocks._StringLiteral((String)"Singleton");
            Pair _mappedTo = Pair.of((Object)"scope", (Object)__StringLiteral);
            result.add(_mappedTo);
        }
        if (it.getOwnedCtor() != null && AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)it.getOwnedCtor())) {
            ArrayLiteral _methodInjectedParams = this.methodInjectedParams(it.getOwnedCtor());
            Pair _mappedTo_1 = Pair.of((Object)"injectCtorParams", (Object)_methodInjectedParams);
            result.add(_mappedTo_1);
        }
        boolean bl = _not = !(_isEmpty = fieldInjectionValue.getElements().isEmpty());
        if (_not) {
            ArrayLiteral _fieldInjection = this.fieldInjection(it);
            Pair _mappedTo_2 = Pair.of((Object)"fieldsInjectedTypes", (Object)_fieldInjection);
            result.add(_mappedTo_2);
        }
        return (Pair[])Conversions.unwrapArray((Object)result, Pair.class);
    }

    private ArrayLiteral methodInjectedParams(TMethod it) {
        ArrayLiteral result = TranspilerBuilderBlocks._ArrLit();
        EList _fpars = it.getFpars();
        for (TFormalParameter fpar : _fpars) {
            SymbolTableEntryOriginal fparSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)fpar, true);
            EList _elements = result.getElements();
            StringLiteral __StringLiteralForSTE = TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)fparSTE);
            Pair _mappedTo = Pair.of((Object)"name", (Object)__StringLiteralForSTE);
            Pair<String, Expression>[] _generateTypeInfo = this.generateTypeInfo(fpar.getTypeRef());
            Iterable _plus = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo})), (Iterable)((Iterable)Conversions.doWrapArray(_generateTypeInfo)));
            ArrayElement __ArrayElement = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._ObjLit((Pair[])((Pair[])Conversions.unwrapArray((Object)_plus, Pair.class))));
            _elements.add((Object)__ArrayElement);
        }
        return result;
    }

    private ArrayLiteral fieldInjection(TClass it) {
        ArrayLiteral result = TranspilerBuilderBlocks._ArrLit();
        Iterable<TField> _ownedInejctedFields = this.getOwnedInejctedFields((TN4Classifier)it);
        for (TField field : _ownedInejctedFields) {
            SymbolTableEntryOriginal fieldSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)field, true);
            EList _elements = result.getElements();
            StringLiteral __StringLiteralForSTE = TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)fieldSTE);
            Pair _mappedTo = Pair.of((Object)"name", (Object)__StringLiteralForSTE);
            Pair<String, Expression>[] _generateTypeInfo = this.generateTypeInfo(field.getTypeRef());
            Iterable _plus = Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Pair[]{_mappedTo})), (Iterable)((Iterable)Conversions.doWrapArray(_generateTypeInfo)));
            ArrayElement __ArrayElement = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._ObjLit((Pair[])((Pair[])Conversions.unwrapArray((Object)_plus, Pair.class))));
            _elements.add((Object)__ArrayElement);
        }
        return result;
    }

    private ArrayLiteral generateBindingPairs(TClass it) {
        ArrayLiteral result = TranspilerBuilderBlocks._ArrLit();
        Iterable<Pair<TN4Classifier, TN4Classifier>> _bindingPairs = this.getBindingPairs(it);
        for (Pair<TN4Classifier, TN4Classifier> binding : _bindingPairs) {
            SymbolTableEntryOriginal keySTE = this.getSymbolTableEntryOriginal((IdentifiableElement)binding.getKey(), true);
            SymbolTableEntryOriginal valueSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)binding.getValue(), true);
            EList _elements = result.getElements();
            ReferencingElementExpression_IM ___NSSafe_IdentRef = this.__NSSafe_IdentRef((SymbolTableEntry)keySTE);
            Pair _mappedTo = Pair.of((Object)"from", (Object)___NSSafe_IdentRef);
            ReferencingElementExpression_IM ___NSSafe_IdentRef_1 = this.__NSSafe_IdentRef((SymbolTableEntry)valueSTE);
            Pair _mappedTo_1 = Pair.of((Object)"to", (Object)___NSSafe_IdentRef_1);
            ArrayElement __ArrayElement = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_mappedTo, _mappedTo_1}));
            _elements.add((Object)__ArrayElement);
        }
        return result;
    }

    private ArrayLiteral generateMethodBindings(TClass it) {
        ArrayLiteral result = TranspilerBuilderBlocks._ArrLit();
        Iterable<TMethod> _ownedProviderMethods = this.getOwnedProviderMethods(it);
        for (TMethod method : _ownedProviderMethods) {
            EList _elements = result.getElements();
            Pair _head = (Pair)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray(this.generateTypeInfo(method.getReturnTypeRef(), "to"))));
            StringLiteral __StringLiteral = TranspilerBuilderBlocks._StringLiteral((String)method.getName());
            Pair _mappedTo = Pair.of((Object)"name", (Object)__StringLiteral);
            ArrayLiteral _methodInjectedParams = this.methodInjectedParams(method);
            Pair _mappedTo_1 = Pair.of((Object)"args", (Object)_methodInjectedParams);
            ArrayElement __ArrayElement = TranspilerBuilderBlocks._ArrayElement((Expression)TranspilerBuilderBlocks._ObjLit((Pair[])new Pair[]{_head, _mappedTo, _mappedTo_1}));
            _elements.add((Object)__ArrayElement);
        }
        return result;
    }

    private ArrayLiteral generateBinders(TClass it) {
        ArrayLiteral result = TranspilerBuilderBlocks._ArrLit();
        List _resolveBinders = DIUtility.resolveBinders((Type)it);
        for (Type binderType : _resolveBinders) {
            SymbolTableEntryOriginal binderTypeSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)binderType, true);
            EList _elements = result.getElements();
            ArrayElement __ArrayElement = TranspilerBuilderBlocks._ArrayElement((Expression)this.__NSSafe_IdentRef((SymbolTableEntry)binderTypeSTE));
            _elements.add((Object)__ArrayElement);
        }
        return result;
    }

    private Pair<String, Expression>[] generateTypeInfo(TypeRef typeRef) {
        return this.generateTypeInfo(typeRef, "type");
    }

    private Pair<String, Expression>[] generateTypeInfo(TypeRef typeRef, String propertyName) {
        boolean _not;
        boolean _isProviderType = DIUtility.isProviderType((TypeRef)typeRef);
        boolean bl = _not = !_isProviderType;
        if (_not) {
            SymbolTableEntryOriginal declaredTypeSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)typeRef.getDeclaredType(), true);
            ReferencingElementExpression_IM ___NSSafe_IdentRef = this.__NSSafe_IdentRef((SymbolTableEntry)declaredTypeSTE);
            Pair _mappedTo = Pair.of((Object)propertyName, (Object)___NSSafe_IdentRef);
            return new Pair[]{_mappedTo};
        }
        if (typeRef instanceof ParameterizedTypeRef) {
            SymbolTableEntryOriginal declaredTypeSTE_1 = this.getSymbolTableEntryOriginal((IdentifiableElement)((ParameterizedTypeRef)typeRef).getDeclaredType(), true);
            ReferencingElementExpression_IM ___NSSafe_IdentRef_1 = this.__NSSafe_IdentRef((SymbolTableEntry)declaredTypeSTE_1);
            Pair _mappedTo_1 = Pair.of((Object)propertyName, (Object)___NSSafe_IdentRef_1);
            ObjectLiteral __ObjLit = TranspilerBuilderBlocks._ObjLit(this.generateTypeInfo((TypeRef)IterableExtensions.head((Iterable)Iterables.filter((Iterable)((ParameterizedTypeRef)typeRef).getTypeArgs(), TypeRef.class))));
            Pair _mappedTo_2 = Pair.of((Object)"typeVar", (Object)__ObjLit);
            return new Pair[]{_mappedTo_1, _mappedTo_2};
        }
        Type _declaredType = null;
        if (typeRef != null) {
            _declaredType = typeRef.getDeclaredType();
        }
        String _name = null;
        if (_declaredType != null) {
            _name = _declaredType.getName();
        }
        String _plus = "cannot generate type info for " + _name;
        throw new IllegalStateException(_plus);
    }

    private Iterable<Pair<TN4Classifier, TN4Classifier>> getBindingPairs(TClass clazz) {
        Functions.Function1 _function = it -> {
            TAnnotationArgument _head = (TAnnotationArgument)IterableExtensions.head((Iterable)it.getArgs());
            Type _declaredType = ((TAnnotationTypeRefArgument)_head).getTypeRef().getDeclaredType();
            TAnnotationArgument _last = (TAnnotationArgument)IterableExtensions.last((Iterable)it.getArgs());
            Type _declaredType_1 = ((TAnnotationTypeRefArgument)_last).getTypeRef().getDeclaredType();
            return Pair.of((Object)((TN4Classifier)_declaredType), (Object)((TN4Classifier)_declaredType_1));
        };
        return IterableExtensions.map((Iterable)AnnotationDefinition.BIND.getAllAnnotations((TAnnotableElement)clazz), (Functions.Function1)_function);
    }

    private Iterable<TMethod> getOwnedProviderMethods(TClass clazz) {
        Functions.Function1 _function = it -> AnnotationDefinition.PROVIDES.hasAnnotation((TAnnotableElement)it);
        return IterableExtensions.filter((Iterable)Iterables.filter((Iterable)clazz.getOwnedMembers(), TMethod.class), (Functions.Function1)_function);
    }

    private Iterable<TField> getOwnedInejctedFields(TN4Classifier clazz) {
        Functions.Function1 _function = it -> AnnotationDefinition.INJECT.hasAnnotation((TAnnotableElement)it);
        return IterableExtensions.filter((Iterable)Iterables.filter((Iterable)clazz.getOwnedMembers(), TField.class), (Functions.Function1)_function);
    }
}

