/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.n4js.cli.compiler.N4jscLanguageClient;

@Singleton
public class N4jscTestLanguageClient
extends N4jscLanguageClient {
    Multimap<String, String> errors = HashMultimap.create();
    Multimap<String, String> warnings = HashMultimap.create();

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        super.publishDiagnostics(diagnostics);
        List issueList = diagnostics.getDiagnostics();
        if (issueList.isEmpty()) {
            return;
        }
        String uriString = this.issueSerializer.uri(diagnostics.getUri());
        for (Diagnostic diag : issueList) {
            String issueString = this.issueSerializer.diagnostics(diag);
            switch (diag.getSeverity()) {
                case Error: {
                    this.errors.put((Object)uriString, (Object)issueString);
                    break;
                }
                case Warning: {
                    this.warnings.put((Object)uriString, (Object)issueString);
                    break;
                }
            }
        }
    }
}

