/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.WildcardPathFilterHelper;

public class NodeModulesDiscoveryHelper {
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;

    public NodeModulesFolder getNodeModulesFolder(Path projectLocation) {
        HashMap<File, List<String>> workspacesCache = new HashMap<File, List<String>>();
        File projectLocationAsFile = projectLocation.toFile();
        if (this.isYarnWorkspaceRoot(projectLocationAsFile, (Optional<File>)Optional.absent(), workspacesCache)) {
            return new NodeModulesFolder(new File(projectLocationAsFile, "node_modules"), true);
        }
        Optional<File> workspaceRoot = this.getYarnWorkspaceRoot(projectLocationAsFile, workspacesCache);
        if (workspaceRoot.isPresent()) {
            return new NodeModulesFolder(new File((File)workspaceRoot.get(), "node_modules"), true);
        }
        Path packgeJsonPath = projectLocation.resolve("package.json");
        if (packgeJsonPath.toFile().isFile()) {
            Path nodeModulesPath = projectLocation.resolve("node_modules");
            return new NodeModulesFolder(nodeModulesPath.toFile(), false);
        }
        return null;
    }

    public List<Path> findNodeModulesFolders(Collection<Path> n4jsProjects) {
        ArrayList<Path> result = new ArrayList<Path>();
        HashMap<File, List<String>> workspacesCache = new HashMap<File, List<String>>();
        LinkedHashSet<File> matchingWorkspaceRoots = new LinkedHashSet<File>();
        for (Path projectFolderPath : n4jsProjects) {
            File projectFolder = (projectFolderPath = projectFolderPath.toAbsolutePath()).toFile();
            if (!projectFolder.isDirectory()) continue;
            Path nodeModulesPath = projectFolderPath.resolve("node_modules");
            result.add(nodeModulesPath);
            Optional<File> workspaceRoot = this.getYarnWorkspaceRoot(projectFolder, workspacesCache);
            if (!workspaceRoot.isPresent()) continue;
            matchingWorkspaceRoots.add((File)workspaceRoot.get());
        }
        for (File workspaceRoot : matchingWorkspaceRoots) {
            Path globalNodeModulesFolderPath = workspaceRoot.toPath().resolve("node_modules");
            result.add(globalNodeModulesFolderPath);
        }
        return result;
    }

    private Optional<File> getYarnWorkspaceRoot(File n4jsProjectFolder, Map<File, List<String>> workspacesCache) {
        File candidate = n4jsProjectFolder.getParentFile();
        while (candidate != null) {
            if (this.isYarnWorkspaceRoot(candidate, (Optional<File>)Optional.of((Object)n4jsProjectFolder), workspacesCache)) {
                return Optional.of((Object)candidate);
            }
            candidate = candidate.getParentFile();
        }
        return Optional.absent();
    }

    public boolean isYarnWorkspaceRoot(File folder) {
        return this.isYarnWorkspaceRoot(folder, (Optional<File>)Optional.absent(), new HashMap<File, List<String>>());
    }

    private boolean isYarnWorkspaceRoot(File folder, Optional<File> projectFolder, Map<File, List<String>> workspacesCache) {
        List<String> workspaces;
        if (!folder.isDirectory()) {
            return false;
        }
        List<String> workspacesFromCache = workspacesCache.get(folder);
        if (workspacesFromCache != null) {
            workspaces = workspacesFromCache;
        } else {
            workspaces = this.projectDescriptionLoader.loadWorkspacesFromProjectDescriptionAtLocation(new FileURI(folder));
            if (workspaces != null) {
                workspacesCache.put(folder, workspaces);
            }
        }
        if (workspaces == null) {
            return false;
        }
        if (projectFolder.isPresent()) {
            for (String relativePath : workspaces) {
                if (!this.isPointingTo(folder, relativePath, (File)projectFolder.get())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isPointingTo(File base, String relativePath, File target) {
        String pattern = String.valueOf(base.getAbsolutePath()) + File.separator + relativePath;
        PathMatcher matcher = WildcardPathFilterHelper.createPathMatcher(pattern);
        return matcher.matches(target.toPath());
    }

    public static class NodeModulesFolder {
        public final File nodeModulesFolder;
        public final boolean isYarnWorkspace;

        public NodeModulesFolder(File nodeModulesFolder, boolean isYarnWorkspace) {
            this.nodeModulesFolder = nodeModulesFolder;
            this.isYarnWorkspace = isYarnWorkspace;
        }
    }
}

