/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.helper.CliCompileProcessResult;
import org.eclipse.n4js.cli.helper.CliCompileResult;
import org.eclipse.n4js.cli.helper.GeneratedJSFilesCounter;
import org.eclipse.n4js.cli.helper.InProcessExecuter;
import org.eclipse.n4js.cli.helper.ProcessResult;
import org.eclipse.n4js.cli.helper.TestProcessExecuter;

public class CliTools {
    private static final String RELATIVE_PATH = "...";
    private final Map<String, String> environment = new HashMap<String, String>();
    private boolean isMirrorSystemOut = false;

    public void callN4jscFrontendInprocess(String[] options, boolean removeUsage, CliCompileResult result) {
        InProcessExecuter inProcessExecuter = new InProcessExecuter(false, this.isMirrorSystemOut);
        inProcessExecuter.n4jsc(new File("").getAbsoluteFile(), options, result);
        CliTools.trimOutputs(result, removeUsage);
    }

    public void callN4jscInprocess(N4jscOptions options, boolean removeUsage, CliCompileResult result) {
        String[] args = (String[])options.toArgs().toArray(String[]::new);
        InProcessExecuter inProcessExecuter = new InProcessExecuter(true, this.isMirrorSystemOut);
        inProcessExecuter.n4jsc((File)options.getDirs().get(0), args, result);
        CliTools.trimOutputs(result, removeUsage);
    }

    public void callN4jscExprocess(N4jscOptions options, boolean removeUsage, CliCompileProcessResult cliResult) {
        List srcFiles = options.getDirs();
        File fileArg = srcFiles.isEmpty() ? new File("").getAbsoluteFile() : (File)srcFiles.get(0);
        ProcessResult n4jscResult = this.getExProcessExecuter().n4jscRun(fileArg.toPath(), this.environment, options);
        cliResult.workingDir = n4jscResult.getWorkingDir();
        cliResult.command = n4jscResult.getCommand();
        cliResult.exception = n4jscResult.getException();
        cliResult.exitCode = n4jscResult.getExitCode();
        cliResult.stdOut = n4jscResult.getStdOut();
        cliResult.errOut = n4jscResult.getErrOut();
        cliResult.transpiledFiles = GeneratedJSFilesCounter.getTranspiledFiles(fileArg.toPath());
        CliTools.trimOutputs(cliResult, removeUsage);
    }

    public void setEnvironmentVariable(String name, String value) {
        this.environment.put(name, value);
    }

    public void setIsMirrorSystemOut(boolean isMirrorSystemOut) {
        this.isMirrorSystemOut = isMirrorSystemOut;
    }

    public ProcessResult runNodejs(Path workingDir, Path runFile, String ... options) {
        return this.getExProcessExecuter().runNodejs(workingDir, this.environment, runFile, options);
    }

    public ProcessResult npmInstall(Path workingDir, String ... options) {
        String[] installOptions = (String[])Lists.asList((Object)"install", (Object[])options).toArray(String[]::new);
        return this.getExProcessExecuter().npmRun(workingDir, this.environment, installOptions);
    }

    public ProcessResult npmList(Path workingDir, String ... options) {
        String[] listOptions = (String[])Lists.asList((Object)"list", (Object[])options).toArray(String[]::new);
        return this.getExProcessExecuter().npmRun(workingDir, this.environment, listOptions);
    }

    public ProcessResult yarnInstall(Path workingDir, String ... options) {
        String[] installOptions = (String[])Lists.asList((Object)"install", (Object[])options).toArray(String[]::new);
        return this.getExProcessExecuter().yarnRun(workingDir, this.environment, installOptions);
    }

    private TestProcessExecuter getExProcessExecuter() {
        Injector injector = N4jscFactory.getOrCreateInjector();
        TestProcessExecuter tpExecuter = new TestProcessExecuter(injector);
        return tpExecuter;
    }

    static void trimOutputs(ProcessResult result, boolean removeUsage) {
        result.stdOut = result.stdOut.replace(result.getWorkingDir(), RELATIVE_PATH);
        result.errOut = result.errOut.replace(result.getWorkingDir(), RELATIVE_PATH);
        if (removeUsage) {
            result.stdOut = result.stdOut.replace("Usage: java -jar n4jsc.jar [GOAL] [DIR(s)] [OPTION(s)]", "");
            result.errOut = result.errOut.replace("Usage: java -jar n4jsc.jar [GOAL] [DIR(s)] [OPTION(s)]", "");
        }
        result.stdOut = result.stdOut.trim();
        result.errOut = result.errOut.trim();
    }
}

