/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.print;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.transpiler.print.LineColTrackingAppendable;
import org.eclipse.n4js.transpiler.sourcemap.FilePosition;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;

class SourceMapAwareAppendable
implements Appendable {
    private final LineColTrackingAppendable out;
    private final boolean collectSourceMapData;
    private final Stack<SourceOutputMapping> openRegions = new Stack();
    private final List<SourceOutputMapping> mappings;

    public SourceMapAwareAppendable(Appendable out, CharSequence indent, boolean collectSourceMapData) {
        this.out = new LineColTrackingAppendable(out, indent);
        this.collectSourceMapData = collectSourceMapData;
        this.mappings = collectSourceMapData ? new ArrayList() : null;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.out.append(c);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.out.append(csq);
        return this;
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.out.append(csq, start, end);
        return this;
    }

    public void newLine() throws IOException {
        this.out.newLine();
    }

    public int getIndentLevel() {
        return this.out.getIndentLevel();
    }

    public void setIndentLevel(int indentLevel) {
        this.out.setIndentLevel(indentLevel);
    }

    public void indent() {
        this.out.indent();
    }

    public void undent() {
        this.out.undent();
    }

    public void openRegion(EObject elementInIntermediateModel) {
        if (elementInIntermediateModel == null) {
            throw new IllegalArgumentException("element in intermediate model may not be null");
        }
        if (!TranspilerUtils.isIntermediateModelElement(elementInIntermediateModel)) {
            throw new IllegalArgumentException("not an element in the intermediate model");
        }
        this.openRegions.push(new SourceOutputMapping(elementInIntermediateModel, this.out.getCurrentPos()));
    }

    public void closeRegion(EObject elementInIntermediateModel) {
        if (elementInIntermediateModel == null) {
            throw new IllegalArgumentException("element in intermediate model may not be null");
        }
        if (!TranspilerUtils.isIntermediateModelElement(elementInIntermediateModel)) {
            throw new IllegalArgumentException("not an element in the intermediate model");
        }
        SourceOutputMapping partialMapping = this.openRegions.pop();
        if (elementInIntermediateModel != partialMapping.elementInIM) {
            throw new IllegalStateException("region open/close mismatch: trying to close region for " + elementInIntermediateModel.eClass().getName() + " but last opened region was for " + partialMapping.elementInIM.eClass().getName());
        }
        if (this.collectSourceMapData) {
            SourceOutputMapping completeMapping = new SourceOutputMapping(partialMapping.elementInIM, partialMapping.outputStart, this.out.getCurrentPos());
            this.mappings.add(completeMapping);
        }
    }

    public List<SourceOutputMapping> getSourceMapData() {
        if (!this.collectSourceMapData) {
            throw new IllegalStateException("source map data not available");
        }
        if (!this.openRegions.isEmpty()) {
            throw new IllegalStateException("trying to obtain source map data before all opened regions were closed");
        }
        return Collections.unmodifiableList(this.mappings);
    }

    public static final class SourceOutputMapping {
        public final EObject elementInIM;
        public final FilePosition outputStart;
        public final FilePosition outputEnd;

        private SourceOutputMapping(EObject elementInIM, FilePosition outputStart) {
            if (elementInIM == null || outputStart == null) {
                throw new IllegalArgumentException();
            }
            this.elementInIM = elementInIM;
            this.outputStart = outputStart;
            this.outputEnd = null;
        }

        public SourceOutputMapping(EObject elementInIM, FilePosition outputStart, FilePosition outputEnd) {
            if (elementInIM == null || outputStart == null || outputEnd == null) {
                throw new IllegalArgumentException();
            }
            this.elementInIM = elementInIM;
            this.outputStart = outputStart;
            this.outputEnd = outputEnd;
        }
    }
}

