/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.ui.navigation;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInSchemeRegistrar;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ts.ui.navigation.IURIBasedStorage;
import org.eclipse.n4js.ts.ui.navigation.N4SchemeURIBasedStorage;
import org.eclipse.xtext.ui.resource.IStorage2UriMapperContribution;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class BuiltinSchemeUriMapperContribution
implements IStorage2UriMapperContribution {
    @Inject
    private BuiltInSchemeRegistrar registrar;

    public void initializeCache() {
    }

    public boolean isRejected(IFolder folder) {
        return false;
    }

    public Iterable<Pair<IStorage, IProject>> getStorages(URI uri) {
        if (N4Scheme.isN4Scheme((URI)uri)) {
            Pair result = Tuples.create((Object)new N4SchemeURIBasedStorage(uri.trimFragment(), this.registrar), null);
            return Collections.singletonList(result);
        }
        return Collections.emptyList();
    }

    public URI getUri(IStorage storage) {
        if (storage instanceof IURIBasedStorage) {
            return ((IURIBasedStorage)storage).getURI();
        }
        return null;
    }
}

