/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.discovery.ErrorMessage;
import org.eclipse.wst.server.discovery.RuntimeProxy;
import org.eclipse.wst.server.discovery.ServerProxy;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.DiscoveryPreferences;
import org.eclipse.wst.server.discovery.internal.IMemento;
import org.eclipse.wst.server.discovery.internal.Messages;
import org.eclipse.wst.server.discovery.internal.ProgressUtil;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.XMLMemento;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.eclipse.wst.server.discovery.internal.model.ExtensionProxy;
import org.eclipse.wst.server.discovery.internal.model.ExtensionUpdateSite;
import org.eclipse.wst.server.discovery.internal.model.IServerExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Comment;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUtility {
    private static final String SERVER_ADAPTER_SITES_DETAILS = "serverAdapterSitesDetails.xml";
    private static Extension[] extensionList = null;
    private static Object tempLock = new Object();
    private static List<ServerProxy> serverExtension = new ArrayList<ServerProxy>();
    private static HashMap<String, Extension> extensionMap = new HashMap();
    private static HashMap<String, ErrorMessage> extensionMapError = new HashMap();
    private static Object cacheFileLock = new Object();
    private static String SERVER_ADAPTER_ID = "org.eclipse.wst.server.core.serverAdapter";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<IServerExtension> getExtensionUpdateSitesDetails(URL url, Extension[] extnList) throws CoreException {
        InputStream in = null;
        try {
            Object object = cacheFileLock;
            synchronized (object) {
                in = url.openStream();
            }
        }
        catch (Exception exception) {
            Trace.trace((byte)3, "Could not load URL " + url);
        }
        if (in == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.discovery", 0, "Could not load extension details", null));
        }
        try {
            IMemento memento;
            Object object = cacheFileLock;
            synchronized (object) {
                memento = XMLMemento.loadMemento(in);
            }
            ArrayList<IServerExtension> list = new ArrayList<IServerExtension>();
            IMemento[] children = memento.getChildren("feature");
            if (extnList != null) {
                ProcessingInstruction processInstrn = ((XMLMemento)memento).getProcessingInstruction();
                Bundle bundle = Activator.getDefault().getBundle();
                SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd yyyy kk:mm:ss zzz", Locale.ENGLISH);
                Date date = new Date(System.currentTimeMillis());
                String dateString = df.format(date);
                String comment = "Generated by " + bundle.getSymbolicName() + " " + bundle.getVersion() + " on " + dateString;
                XMLMemento newMemento = null;
                newMemento = processInstrn == null ? XMLMemento.createWriteRoot("extensionDetails", "serverAdapter", "version=\"3\"", comment) : XMLMemento.createWriteRoot("extensionDetails", processInstrn.getTarget(), processInstrn.getData(), comment);
                int j = 0;
                while (j < extnList.length) {
                    IMemento childMemento = newMemento.createChild("feature");
                    String vendor = extnList[j].getRuntimeVendor();
                    String serverId = extnList[j].getServerId();
                    String runtimeId = extnList[j].getRuntimeId();
                    childMemento.putString("id", extnList[j].getId());
                    childMemento.putString("description", extnList[j].getDescription());
                    childMemento.putString("name", extnList[j].getName());
                    childMemento.putString("uri", extnList[j].getURI());
                    childMemento.putString("version", extnList[j].getVersion().toString());
                    childMemento.putString("provider", extnList[j].getProvider());
                    childMemento.putString("serverId", serverId);
                    childMemento.putString("runtimeId", runtimeId);
                    int i = 0;
                    while (i < children.length) {
                        if (children[i].getString("id").equals(extnList[j].getId())) {
                            if (vendor == null || vendor != null && vendor.length() == 0) {
                                childMemento.putString("provider", children[i].getString("provider"));
                                childMemento.putString("vendor", children[i].getString("runtime-vendor"));
                            } else {
                                childMemento.putString("vendor", vendor);
                            }
                            if (serverId == null || serverId != null && serverId.length() == 0) {
                                childMemento.putString("serverId", children[i].getString("serverId"));
                            } else {
                                childMemento.putString("serverId", serverId);
                            }
                            if (runtimeId == null || runtimeId != null && runtimeId.length() == 0) {
                                childMemento.putString("runtimeId", children[i].getString("runtimeId"));
                                break;
                            }
                            childMemento.putString("runtimeId", runtimeId);
                            break;
                        }
                        ++i;
                    }
                    ExtensionProxy item = new ExtensionProxy(childMemento.getString("id"), childMemento.getString("name"), childMemento.getString("description"), childMemento.getString("provider"), childMemento.getString("uri"), childMemento.getString("version"), childMemento.getString("serverId"), childMemento.getString("vendor"), childMemento.getString("runtimeId"));
                    list.add(item);
                    ++j;
                }
                Object object2 = cacheFileLock;
                synchronized (object2) {
                    newMemento.saveToFile(url.toURI().getPath());
                }
                DiscoveryPreferences.getInstance().setCacheLastUpdatedDate(dateString.trim());
            } else {
                ProcessingInstruction processInstrn = ((XMLMemento)memento).getProcessingInstruction();
                if (processInstrn != null && processInstrn.getNextSibling() instanceof Comment) {
                    Comment comment = (Comment)processInstrn.getNextSibling();
                    String commentText = comment.getTextContent();
                    int index = commentText.indexOf(" on ");
                    if (index == -1) {
                        DiscoveryPreferences.getInstance().setCacheLastUpdatedDate(Messages.cacheUpdate_Never);
                    } else {
                        String dateString = commentText.substring(index + 3);
                        DiscoveryPreferences.getInstance().setCacheLastUpdatedDate(dateString);
                    }
                } else {
                    DiscoveryPreferences.getInstance().setCacheLastUpdatedDate(Messages.cacheUpdate_Never);
                }
                int i = 0;
                while (i < children.length) {
                    ExtensionProxy item = new ExtensionProxy(children[i].getString("id"), children[i].getString("name"), children[i].getString("description"), children[i].getString("provider"), children[i].getString("uri"), children[i].getString("version"), children[i].getString("serverId"), children[i].getString("vendor"), children[i].getString("runtimeId"));
                    list.add(item);
                    ++i;
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.discovery", 0, e.getMessage(), (Throwable)e));
        }
    }

    private static ExtensionUpdateSite[] getExtensionUpdateSites(URL url) throws CoreException {
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception exception) {
            Trace.trace((byte)3, "Could not load URL " + url);
        }
        if (in == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.discovery", 0, "Could not load extensions", null));
        }
        try {
            IMemento memento = XMLMemento.loadMemento(in);
            IMemento[] children = memento.getChildren("site");
            int size = children.length;
            ArrayList<ExtensionUpdateSite> list = new ArrayList<ExtensionUpdateSite>(size);
            int i = 0;
            while (i < size) {
                String url2 = children[i].getString("url");
                ExtensionUpdateSite item = new ExtensionUpdateSite(url2, null, null);
                list.add(item);
                ++i;
            }
            ExtensionUpdateSite[] items = new ExtensionUpdateSite[list.size()];
            list.toArray(items);
            return items;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.discovery", 0, e.getMessage(), (Throwable)e));
        }
    }

    private static void copyFileUsingFileStreams(InputStream input, File dest) throws IOException {
        if (input == null) {
            throw new IOException("Input stream is null");
        }
        FileOutputStream output = null;
        try {
            int bytesRead;
            output = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                ((OutputStream)output).write(buf, 0, bytesRead);
            }
        }
        finally {
            input.close();
            if (output != null) {
                ((OutputStream)output).close();
            }
        }
    }

    private static List<IServerExtension> getExtensionUpdateSitesDetails(Extension[] extenList) {
        try {
            URL cacheFileUrl = null;
            File workspaceFile = new File(String.valueOf(Activator.getDefault().getStateLocation().toOSString()) + File.separator + SERVER_ADAPTER_SITES_DETAILS);
            if (workspaceFile.exists()) {
                cacheFileUrl = workspaceFile.toURI().toURL();
            } else {
                File configDir = ExtensionUtility.getConfigDir();
                File configFile = new File(String.valueOf(configDir.getAbsolutePath()) + File.separator + SERVER_ADAPTER_SITES_DETAILS);
                if (configFile.exists()) {
                    cacheFileUrl = configFile.toURI().toURL();
                } else {
                    URL masterCopyUrl = Activator.getDefault().getBundle().getEntry(SERVER_ADAPTER_SITES_DETAILS);
                    boolean configFileAreaExists = configDir.exists();
                    if (!configFileAreaExists) {
                        try {
                            configFileAreaExists = configDir.mkdirs();
                        }
                        catch (Exception e) {
                            Trace.trace((byte)2, "Cannot write to configuration", e);
                            configFileAreaExists = false;
                        }
                    }
                    if (configFileAreaExists) {
                        try {
                            ExtensionUtility.copyFileUsingFileStreams(masterCopyUrl.openStream(), configFile);
                            cacheFileUrl = configFile.toURI().toURL();
                        }
                        catch (IOException e) {
                            Trace.trace((byte)2, "Cannot write to configuration", e);
                        }
                    }
                    if (cacheFileUrl == null) {
                        try {
                            File workspaceFileArea = workspaceFile.getParentFile();
                            boolean workspaceFileAreaExists = workspaceFileArea.exists();
                            if (!workspaceFileAreaExists) {
                                try {
                                    workspaceFileAreaExists = workspaceFileArea.mkdirs();
                                }
                                catch (Exception e) {
                                    Trace.trace((byte)3, "Cannot write to workspace", e);
                                    workspaceFileAreaExists = false;
                                }
                            }
                            if (workspaceFileAreaExists) {
                                ExtensionUtility.copyFileUsingFileStreams(masterCopyUrl.openStream(), workspaceFile);
                                cacheFileUrl = workspaceFile.toURI().toURL();
                            }
                        }
                        catch (Exception e) {
                            Trace.trace((byte)3, "Cannot write to workspace", e);
                        }
                    }
                    if (cacheFileUrl == null) {
                        cacheFileUrl = masterCopyUrl;
                    }
                }
            }
            Trace.trace((byte)1, "cacheFile=" + cacheFileUrl);
            return ExtensionUtility.getExtensionUpdateSitesDetails(cacheFileUrl, extenList);
        }
        catch (CoreException ce) {
            Trace.trace((byte)3, "Could not get extension items details", ce);
        }
        catch (MalformedURLException e) {
            Trace.trace((byte)3, "Could not get extension items details", e);
        }
        catch (IOException e) {
            Trace.trace((byte)3, "Could not get extension items details", e);
        }
        catch (URISyntaxException e) {
            Trace.trace((byte)3, "Could not get extension items details", e);
        }
        return new ArrayList<IServerExtension>();
    }

    private static File getConfigDir() throws IOException, URISyntaxException {
        Location cfgLoc = Platform.getConfigurationLocation();
        URL cfgDataUrl = cfgLoc.getDataArea("org.eclipse.wst.server.discovery");
        return new File(cfgDataUrl.getFile());
    }

    private static ExtensionUpdateSite[] getExtensionUpdateSites() {
        URL url = Activator.getDefault().getBundle().getEntry("serverAdapterSites.xml");
        try {
            return ExtensionUtility.getExtensionUpdateSites(url);
        }
        catch (CoreException coreException) {
            Trace.trace((byte)3, "Could not get extension items");
            return new ExtensionUpdateSite[0];
        }
    }

    private static boolean alreadyExists(List<Extension> existing, IServerExtension newFeature) {
        if (existing.contains(newFeature)) {
            return true;
        }
        Version newV = newFeature.getVersion();
        for (IServerExtension iServerExtension : existing) {
            if (!iServerExtension.getId().equals(newFeature.getId())) continue;
            if (newV == null) {
                return true;
            }
            if (iServerExtension.getVersion().compareTo((Object)newV) < 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addExtension(List<IServerExtension> list, List<Extension> existing, IServerExtension newFeature, ExtensionListener listener) {
        if (ExtensionUtility.alreadyExists(existing, newFeature)) {
            return;
        }
        List<IServerExtension> list2 = list;
        synchronized (list2) {
            Version newV = newFeature.getVersion();
            IServerExtension remove = null;
            for (IServerExtension feature : list) {
                if (!feature.getId().equals(newFeature.getId())) continue;
                if (newV == null) {
                    return;
                }
                if (feature.getVersion().compareTo((Object)newV) < 0) {
                    remove = feature;
                    continue;
                }
                return;
            }
            if (remove != null) {
                list.remove(remove);
                if (listener != null) {
                    listener.extensionRemoved((Extension)remove);
                }
            }
            list.add(newFeature);
        }
        if (listener != null) {
            listener.extensionFound((Extension)newFeature);
        }
        if (listener == null && newFeature instanceof ExtensionProxy) {
            serverExtension.add(ExtensionUtility.createServerProxy((ExtensionProxy)newFeature));
        }
    }

    private static ServerProxy createServerProxy(ExtensionProxy newFeature) {
        String runtimeVendor = newFeature.getRuntimeVendor();
        if (runtimeVendor == null || runtimeVendor != null && runtimeVendor.length() == 0) {
            runtimeVendor = newFeature.getProvider();
        }
        RuntimeProxy runtimeProxy = new RuntimeProxy("com.eclipse.runtime.proxy", newFeature.getName(), newFeature.getDescription(), runtimeVendor);
        runtimeProxy.setProxyRuntimeId(newFeature.getRuntimeId());
        ServerProxy serverProxy = new ServerProxy("com.eclipse.server.proxy", newFeature.getName(), newFeature.getDescription(), runtimeProxy, newFeature.getId(), newFeature.getURI(), newFeature.getServerId());
        return serverProxy;
    }

    protected static void addExtensions(List<IServerExtension> list, List<Extension> existing, List<IServerExtension> newFeatures, ExtensionListener listener) {
        Iterator<IServerExtension> iterator = newFeatures.iterator();
        while (iterator.hasNext()) {
            ExtensionUtility.addExtension(list, existing, iterator.next(), listener);
        }
    }

    private static List<Extension> getExistingFeatures(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.discoverLocalConfiguration, 100);
        IProfileRegistry profileRegistry = (IProfileRegistry)ExtensionUtility.getService(Activator.getDefault().getBundle().getBundleContext(), IProfileRegistry.class.getName());
        IProfile[] profiles = profileRegistry.getProfiles();
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            int i = 0;
            while (i < profiles.length) {
                if (profiles[i].getProfileId().equals("_SELF_")) {
                    profile = profiles[i];
                    break;
                }
                ++i;
            }
        }
        ArrayList<Extension> list = new ArrayList<Extension>();
        if (profile == null) {
            return list;
        }
        IQuery query = QueryUtil.createIUAnyQuery();
        IQueryResult collector = profile.query(query, monitor);
        for (IInstallableUnit iu : collector) {
            if (list.contains(iu)) continue;
            list.add(new Extension(iu, null));
        }
        monitor.done();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExtensionList(Extension[] extList) {
        Object object = tempLock;
        synchronized (object) {
            extensionList = extList;
        }
    }

    public static Extension[] getAllExtensionsWithServer(String id, IProgressMonitor monitor) throws CoreException {
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask("", 1100);
        monitor.subTask(Messages.discoverLocalConfiguration);
        List<Extension> existing = ExtensionUtility.getExistingFeatures(ProgressUtil.getSubMonitorFor(monitor, 100));
        List<IServerExtension> extensionCached = ExtensionUtility.getExtensionUpdateSitesDetails(null);
        ArrayList<IServerExtension> list = new ArrayList<IServerExtension>();
        if (extensionCached != null && extensionCached.size() != 0) {
            ExtensionUtility.addExtensions(list, existing, extensionCached, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Extension[] getAllExtensions(String id, final ExtensionListener listener, IProgressMonitor monitor) throws CoreException {
        Object object = tempLock;
        synchronized (object) {
            if (extensionList != null && extensionList.length != 0 && listener != null) {
                int i = 0;
                while (i < extensionList.length) {
                    listener.extensionFound(extensionList[i]);
                    ++i;
                }
                return extensionList;
            }
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask("", 1100);
            monitor.subTask(Messages.discoverLocalConfiguration);
            final List<Extension> existing = ExtensionUtility.getExistingFeatures(ProgressUtil.getSubMonitorFor(monitor, 100));
            final ExtensionUpdateSite[] items = ExtensionUtility.getExtensionUpdateSites();
            if (items == null || items.length == 0) {
                return new Extension[0];
            }
            final int x = 1000 / items.length;
            monitor.worked(50);
            final ArrayList list = new ArrayList();
            int size = items.length;
            Thread[] threads = new Thread[size];
            int i = 0;
            while (i < size) {
                try {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    monitor.subTask(NLS.bind((String)Messages.discoverSearching, (Object)items[i].getUrl()));
                    final int ii = i;
                    final IProgressMonitor monitor2 = monitor;
                    threads[i] = new Thread("Extension Checker for " + items[i].getUrl()){

                        public void run() {
                            try {
                                List<IServerExtension> list2 = items[ii].getExtensions(ProgressUtil.getSubMonitorFor(monitor2, x));
                                ExtensionUtility.addExtensions(list, existing, list2, listener);
                            }
                            catch (CoreException ce) {
                                if (listener != null) {
                                    listener.siteFailure(ce.getLocalizedMessage());
                                }
                                Trace.trace((byte)2, "Error downloading extension info", ce);
                            }
                        }
                    };
                    threads[i].setDaemon(true);
                    threads[i].start();
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Error downloading extension info 2", e);
                }
                ++i;
            }
            i = 0;
            while (i < size) {
                try {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (threads[i].isAlive()) {
                        threads[i].join();
                    }
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Error downloading extension info 3", e);
                }
                ++i;
            }
            Extension[] ef = new Extension[list.size()];
            list.toArray(ef);
            monitor.done();
            extensionList = ef;
            return ef;
        }
    }

    public static List<ServerProxy> getExtensionsWithServer(IProgressMonitor monitor) {
        if (serverExtension == null || serverExtension.isEmpty()) {
            try {
                ExtensionUtility.getAllExtensionsWithServer(SERVER_ADAPTER_ID, monitor);
            }
            catch (CoreException coreException) {
                Trace.trace((byte)3, "Could not load server adapter list");
            }
        }
        return serverExtension;
    }

    public static String getLicenseText(String extensionId) {
        Extension extension = extensionMap.get(extensionId);
        if (extension != null) {
            return extension.getLicense();
        }
        return null;
    }

    public static Object getService(BundleContext context, String name) {
        ServiceReference reference = context.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (reference == null) {
            return null;
        }
        IProvisioningAgent result = ExtensionUtility.getAgent(context);
        if (result == null) {
            return null;
        }
        try {
            Object object = result.getService(name);
            return object;
        }
        finally {
            context.ungetService(reference);
        }
    }

    public static IProvisioningAgent getAgent(BundleContext context) {
        ServiceReference reference = context.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (reference == null) {
            return null;
        }
        IProvisioningAgent result = (IProvisioningAgent)context.getService(reference);
        return result;
    }

    public static boolean installExtension(final Extension extension) {
        if (extension == null) {
            return false;
        }
        String name = NLS.bind((String)Messages.installJobName, (Object)extension.getName());
        Job job = new Job(name){

            public IStatus run(IProgressMonitor monitor) {
                return extension.install(monitor);
            }
        };
        ProvisioningOperationRunner por = new ProvisioningOperationRunner(ProvisioningUI.getDefaultUI());
        por.manageJob(job, 2);
        job.setUser(true);
        job.schedule();
        return true;
    }

    public static boolean installExtension(String extensionId) {
        return ExtensionUtility.installExtension(extensionMap.get(extensionId));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ErrorMessage refreshExtension(String extensionId, String uri, IProgressMonitor monitor) {
        ErrorMessage errorMessageObj = null;
        if (extensionMap.get(extensionId) != null && extensionMapError.get(extensionId) == null) {
            return null;
        }
        ExtensionUpdateSite site = new ExtensionUpdateSite(uri, null, null);
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask("", 1000);
            monitor.subTask(Messages.fetchingRepository);
            IProgressMonitor subMonitor = ProgressUtil.getSubMonitorFor(monitor, 500);
            List<IServerExtension> list = site.getExtensions(subMonitor);
            monitor.worked(500);
            if (monitor.isCanceled()) {
                return null;
            }
            boolean firstIteration = true;
            for (IServerExtension iServerExtension : list) {
                if (!iServerExtension.getId().equals(extensionId)) continue;
                Extension extension = (Extension)iServerExtension;
                if (extensionMap.get(extensionId) != null && !firstIteration && extension.getVersion().compareTo((Object)extensionMap.get(extensionId).getVersion()) <= 0) continue;
                subMonitor = ProgressUtil.getSubMonitorFor(monitor, 500);
                monitor.subTask(Messages.validateInstall);
                IProvisioningPlan plan = extension.getProvisioningPlan(true, subMonitor);
                if (monitor.isCanceled()) {
                    return null;
                }
                if (plan == null || !plan.getStatus().isOK()) {
                    if (plan != null) {
                        StringBuffer detailedErrorMsg = new StringBuffer();
                        IStatus[] statusList = plan.getStatus().getChildren();
                        int i = 0;
                        while (i < statusList.length) {
                            detailedErrorMsg.append(statusList[i].getMessage());
                            ++i;
                        }
                        errorMessageObj = new ErrorMessage(Messages.validateInstallError, detailedErrorMsg.toString());
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.wst.server.discovery", detailedErrorMsg.toString(), plan.getStatus().getException()));
                    } else {
                        errorMessageObj = new ErrorMessage(Messages.validateInstallError, Messages.fetchingRepositoryFailure);
                        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.wst.server.discovery", "Could not get the provisioning plan", null));
                    }
                }
                extensionMap.put(extensionId, extension);
                extensionMapError.put(extensionId, errorMessageObj);
                firstIteration = false;
            }
            return errorMessageObj;
        }
        catch (CoreException e) {
            Trace.trace((byte)3, "Could not refresh server adapter node.");
            return new ErrorMessage(Messages.fetchingRepositoryFailure, e.getLocalizedMessage());
        }
    }

    public static void refreshServerAdapters(IProgressMonitor monitor) {
        ExtensionUtility.getExtensionsWithServer(monitor);
        try {
            Extension[] extnList = ExtensionUtility.getAllExtensions(SERVER_ADAPTER_ID, null, monitor);
            if (extnList != null && extnList.length > 0) {
                ExtensionUtility.getExtensionUpdateSitesDetails(extnList);
                serverExtension = new ArrayList<ServerProxy>();
            }
        }
        catch (CoreException coreException) {
            Trace.trace((byte)3, "Could not refresh server adapter list.");
        }
    }

    public static interface ExtensionListener {
        public void extensionFound(Extension var1);

        public void extensionRemoved(Extension var1);

        public void siteFailure(String var1);
    }
}

