/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.analysis.NoPath;
import org.eclipse.n4js.flowgraphs.analysis.Path;
import org.eclipse.n4js.flowgraphs.analysis.SuccessorPredecessorAnalysis;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.FlowGraph;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class DirectPathAnalyses {
    private final FlowGraph cfg;
    private final SuccessorPredecessorAnalysis spa;

    public DirectPathAnalyses(FlowGraph cfg) {
        this.cfg = cfg;
        this.spa = new SuccessorPredecessorAnalysis(cfg);
    }

    public TreeSet<ControlFlowType> getControlFlowTypeToSuccessors(ControlFlowElement cfe, ControlFlowElement cfeSucc) {
        Path path = this.getPath(cfe, cfeSucc);
        if (path.isConnecting()) {
            return path.getControlFlowTypes();
        }
        throw new IllegalArgumentException("No path found between given ControlFlowElements");
    }

    public boolean isTransitiveSuccessor(ControlFlowElement cfeFrom, ControlFlowElement cfeTo, ControlFlowElement cfeNotVia) {
        Objects.requireNonNull(cfeFrom);
        Objects.requireNonNull(cfeTo);
        Path path = this.getPath(cfeFrom, cfeTo, cfeNotVia);
        return path.isConnecting();
    }

    public Set<ControlFlowElement> getCommonPredecessors(ControlFlowElement cfeA, ControlFlowElement cfeB) {
        Objects.requireNonNull(cfeA);
        Objects.requireNonNull(cfeB);
        LinkedHashSet<ControlFlowElement> commonPredSet = new LinkedHashSet<ControlFlowElement>();
        commonPredSet.addAll(this.getSomeCommonPredecessors(cfeA, cfeB));
        commonPredSet.addAll(this.getSomeCommonPredecessors(cfeB, cfeA));
        return commonPredSet;
    }

    private Set<ControlFlowElement> getSomeCommonPredecessors(ControlFlowElement cfeA, ControlFlowElement cfeB) {
        LinkedHashSet<ControlFlowElement> commonPredSet = new LinkedHashSet<ControlFlowElement>();
        HashSet<ControlFlowElement> marked = new HashSet<ControlFlowElement>();
        LinkedList<ControlFlowElement> curCFEs = new LinkedList<ControlFlowElement>();
        curCFEs.add(cfeA);
        while (!curCFEs.isEmpty()) {
            ControlFlowElement cfe = (ControlFlowElement)curCFEs.removeFirst();
            if (marked.contains(cfe)) continue;
            marked.add(cfe);
            Set<ControlFlowElement> preds = this.spa.getPredecessors(cfe);
            curCFEs.addAll(preds);
        }
        HashSet<ControlFlowElement> visited = new HashSet<ControlFlowElement>();
        curCFEs.clear();
        curCFEs.add(cfeB);
        while (!curCFEs.isEmpty()) {
            ControlFlowElement cfe = (ControlFlowElement)curCFEs.removeFirst();
            if (marked.contains(cfe)) {
                commonPredSet.add(cfe);
                continue;
            }
            if (visited.contains(cfe)) continue;
            visited.add(cfe);
            Set<ControlFlowElement> preds = this.spa.getPredecessors(cfe);
            curCFEs.addAll(preds);
        }
        return commonPredSet;
    }

    public Path getPath(ControlFlowElement cfeFrom, ControlFlowElement cfeTo) {
        return this.getPath(cfeFrom, cfeTo, null);
    }

    public Path getPath(ControlFlowElement cfeFrom, ControlFlowElement cfeTo, ControlFlowElement cfeNotVia) {
        ComplexNode cnStart = this.cfg.getComplexNode(cfeFrom);
        ComplexNode cnEnd = this.cfg.getComplexNode(cfeTo);
        RepresentingNode nStart = cnStart.getRepresent();
        RepresentingNode nEnd = cnEnd.getRepresent();
        RepresentingNode nNotVia = null;
        if (cfeNotVia != null) {
            ComplexNode cnNotVia = this.cfg.getComplexNode(cfeNotVia);
            nNotVia = cnNotVia.getRepresent();
        }
        Path path = this.buildPath(nStart, nEnd, nNotVia);
        return path;
    }

    private Path buildPath(Node start, Node end, Node notVia) {
        NextEdgesProvider.Forward forwardEdgeProvider = new NextEdgesProvider.Forward();
        LinkedList<ControlFlowEdge> pathEdges = this.findPath(start, end, notVia, forwardEdgeProvider);
        Path path = null;
        path = pathEdges != null ? new Path(start, end, pathEdges, forwardEdgeProvider) : new NoPath(start, end, forwardEdgeProvider);
        return path;
    }

    private LinkedList<ControlFlowEdge> findPath(Node startNode, Node endNode, Node notVia, NextEdgesProvider edgeProvider) {
        if (startNode == endNode) {
            return Lists.newLinkedList();
        }
        LinkedList<LinkedList<ControlFlowEdge>> allPaths = new LinkedList<LinkedList<ControlFlowEdge>>();
        List<ControlFlowEdge> nextEdges = edgeProvider.getNextEdges(startNode, ControlFlowType.NonDeadTypes);
        for (ControlFlowEdge nextEdge : nextEdges) {
            LinkedList<ControlFlowEdge> linkedList = new LinkedList<ControlFlowEdge>();
            linkedList.add(nextEdge);
            if (this.isEndNode(edgeProvider, endNode, nextEdge)) {
                return linkedList;
            }
            allPaths.add(linkedList);
        }
        while (!allPaths.isEmpty()) {
            LinkedList firstPath = (LinkedList)allPaths.removeFirst();
            LinkedList<LinkedList<ControlFlowEdge>> ch = this.getPaths(edgeProvider, firstPath, notVia);
            for (LinkedList linkedList : ch) {
                if (!this.isEndNode(edgeProvider, endNode, (ControlFlowEdge)linkedList.getLast())) continue;
                return linkedList;
            }
            allPaths.addAll(ch);
        }
        return null;
    }

    private LinkedList<LinkedList<ControlFlowEdge>> getPaths(NextEdgesProvider edgeProvider, LinkedList<ControlFlowEdge> path, Node notVia) {
        LinkedList<LinkedList<ControlFlowEdge>> resultPaths = new LinkedList<LinkedList<ControlFlowEdge>>();
        ControlFlowEdge e = path.getLast();
        Node nextNode = edgeProvider.getNextNode(e);
        List<ControlFlowEdge> nextEdges = edgeProvider.getNextEdges(nextNode, ControlFlowType.NonDeadTypes);
        for (ControlFlowEdge nextEdge : nextEdges) {
            Node uberNextNode = edgeProvider.getNextNode(nextEdge);
            if (notVia != null && notVia == uberNextNode) continue;
            LinkedList pathCopy = path;
            if (nextEdges.size() > 1) {
                pathCopy = Lists.newLinkedList(pathCopy);
            }
            pathCopy.add(nextEdge);
            resultPaths.add(pathCopy);
        }
        return resultPaths;
    }

    private boolean isEndNode(NextEdgesProvider edgeProvider, Node node, ControlFlowEdge edge) {
        return edgeProvider.getNextNode(edge) == node;
    }
}

