/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.n4js.tester.TestDiscoveryHelper;
import org.eclipse.n4js.tester.TestTreeTransformer;
import org.eclipse.n4js.tester.domain.TestTree;

public class TestCatalogSupplier
implements Supplier<String> {
    @Inject
    private ObjectMapper objectMapper;
    @Inject
    private TestTreeTransformer treeTransformer;
    @Inject
    private TestDiscoveryHelper testDiscoveryHelper;

    public String get() {
        return this.get(false);
    }

    public String get(boolean suppressEndpointProperty) {
        try {
            System.out.println("before getTreeForAllTests()");
            TestTree testTree = this.getTreeForAllTests();
            System.out.println("before treeTransformer.apply(testTree, Collections.emptyMap())");
            Object testCatalogObject = suppressEndpointProperty ? this.treeTransformer.apply(testTree, Collections.emptyMap()) : this.treeTransformer.apply(testTree);
            System.out.println("before objectMapper.writeValueAsString(testCatalogObject)");
            return this.objectMapper.writeValueAsString(testCatalogObject);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while assembling test catalog.", e);
        }
    }

    protected TestTree getTreeForAllTests() {
        return this.testDiscoveryHelper.collectAllTestsFromWorkspace();
    }
}

