/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.ui.TesterUiActivator;
import org.eclipse.n4js.tester.ui.resultsview.TestResultsView;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ShowHistoryAction
extends Action {
    private final TestResultsView view;

    public ShowHistoryAction(TestResultsView view) {
        super("Show History", 4);
        this.view = view;
        this.setToolTipText("Show list of recent test sessions.");
        this.setImageDescriptor(TesterUiActivator.getImageDescriptor("history_list.gif"));
        this.setMenuCreator(new HistoryMenuCreator());
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenuCreator().getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }

    private final class HistoryMenuCreator
    implements IMenuCreator {
        private Menu menu;

        private HistoryMenuCreator() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu((Decorations)parent.getShell(), 8);
            for (TestTree currTree : ShowHistoryAction.this.view.getTestTrees()) {
                this.addActionToMenu(this.menu, new ShowSessionAction(currTree));
            }
            this.addSeparator(this.menu);
            this.addActionToMenu(this.menu, ShowHistoryAction.this.view.getActionClearTerminated());
            return this.menu;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        protected MenuItem addSeparator(Menu parent) {
            return new MenuItem(parent, 2);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }
    }

    private final class ShowSessionAction
    extends Action {
        private final TestTree tree;

        public ShowSessionAction(TestTree root) {
            this.tree = root;
            this.setText(root.getName());
            this.setEnabled(root != ShowHistoryAction.this.view.getShownTestTree());
        }

        public void run() {
            ShowHistoryAction.this.view.setShownTestTree(this.tree.getSessionId());
        }
    }
}

