/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.services;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xpect.ui.util.XpectFileAccess;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XtLanguageSpecificURIEditorOpener
implements IURIEditorOpener {
    private static final Logger logger = Logger.getLogger(XtLanguageSpecificURIEditorOpener.class);
    @Inject
    private IStorage2UriMapper mapper;
    @Inject(optional=true)
    private IWorkbench workbench;

    public IEditorPart open(URI uri, boolean select) {
        return this.open(uri, null, -1, select);
    }

    public IEditorPart open(URI uri, EReference crossReference, int indexInList, boolean select) {
        Iterator storages = this.mapper.getStorages(uri.trimFragment()).iterator();
        if (storages != null && storages.hasNext()) {
            try {
                IStorage storage = (IStorage)((Pair)storages.next()).getFirst();
                FileEditorInput editorInput = storage instanceof IFile ? new FileEditorInput((IFile)storage) : new XtextReadonlyEditorInput(storage);
                IWorkbenchPage activePage = this.workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)editorInput, (String)"org.eclipse.xpect.Xt");
                this.selectAndReveal(editor, uri, crossReference, indexInList, select);
                return EditorUtils.getXtextEditor((IEditorPart)editor);
            }
            catch (WrappedException e) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), e.getCause());
            }
            catch (PartInitException partInitException) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), (Throwable)partInitException);
            }
        }
        return null;
    }

    protected void selectAndReveal(IEditorPart openEditor, final URI uri, final EReference crossReference, final int indexInList, final boolean select) {
        final XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)openEditor);
        if (xtextEditor != null) {
            xtextEditor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource resource) throws Exception {
                    ITextRegion location;
                    if (resource == null) {
                        return;
                    }
                    EObject object = XtLanguageSpecificURIEditorOpener.this.findEObjectByURI(uri, resource);
                    if (object == null) {
                        return;
                    }
                    ILocationInFileProvider locationProvider = (ILocationInFileProvider)((XtextResource)object.eResource()).getResourceServiceProvider().get(ILocationInFileProvider.class);
                    ITextRegion iTextRegion = location = crossReference != null ? locationProvider.getSignificantTextRegion(object, (EStructuralFeature)crossReference, indexInList) : locationProvider.getSignificantTextRegion(object);
                    if (select) {
                        xtextEditor.selectAndReveal(location.getOffset(), location.getLength());
                    } else {
                        xtextEditor.reveal(location.getOffset(), location.getLength());
                    }
                }
            });
        }
    }

    protected EObject findEObjectByURI(URI uri, XtextResource resource) {
        if (uri.fragment() != null) {
            try {
                XtextResource xpectResource = XpectFileAccess.getXpectResource((Resource)resource);
                EObject result = xpectResource.getEObject(uri.fragment());
                return result;
            }
            catch (WrappedException xpectResource) {
            }
            catch (IllegalArgumentException xpectResource) {
                // empty catch block
            }
            try {
                EObject result = resource.getEObject(uri.fragment());
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

