/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.n4js.ui.workingsets.ManualAssociationAwareWorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetDiffBuilder;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerModificationStrategyImpl;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.n4js.utils.collections.Arrays2;
import org.eclipse.ui.IWorkingSet;

public class AddWorkingSetModificationStrategy
extends WorkingSetManagerModificationStrategyImpl {
    static final int APPEND_TO_END_INDEX = -2;
    private final IWorkingSet toAdd;
    private final int newItemsIndex;
    private final int newAllItemsIndex;

    public AddWorkingSetModificationStrategy(IWorkingSet toAdd) {
        this(toAdd, -2, -2);
    }

    public AddWorkingSetModificationStrategy(IWorkingSet toAdd, int newItemsIndex, int newAllItemsIndex) {
        this.toAdd = toAdd;
        this.newItemsIndex = newItemsIndex;
        this.newAllItemsIndex = newAllItemsIndex;
    }

    @Override
    public void execute(WorkingSetManager manager) {
        if (this.toAdd != null && "org.eclipse.ui.resourceWorkingSetPage".equals(this.toAdd.getId())) {
            String name = this.toAdd.getName();
            if (this.getWorkingSetByName(manager, name) != null) {
                return;
            }
            Object[] projects = (IProject[])Arrays2.filter((Object[])this.toAdd.getElements(), IProject.class);
            List projectNames = Arrays2.transform((Object[])projects, p -> p.getName());
            ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet newWorkingSet = new ManualAssociationAwareWorkingSetManager.ManualAssociationWorkingSet(projectNames, name, manager);
            WorkingSetDiffBuilder builder = new WorkingSetDiffBuilder(manager);
            builder.add(newWorkingSet);
            ArrayList newItems = Lists.newArrayList((Object[])manager.getWorkingSets());
            if (this.newItemsIndex == -2) {
                newItems.add(newWorkingSet);
            } else if (this.newItemsIndex >= 0) {
                newItems.add(this.newItemsIndex, newWorkingSet);
            }
            ArrayList newAllItems = Lists.newArrayList((Object[])manager.getAllWorkingSets());
            if (this.newAllItemsIndex == -2) {
                newAllItems.add(newWorkingSet);
            } else if (this.newAllItemsIndex >= 0) {
                newAllItems.add(this.newAllItemsIndex, newWorkingSet);
            }
            Diff<WorkingSet> diff = builder.build(newItems, newAllItems);
            this.updateAndSaveState(manager, diff);
        }
    }
}

