/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.JavaBinary;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.binaries.nodejs.NodeYarnProcessBuilder;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.binaries.nodejs.YarnBinary;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.utils.OSInfo;

public class TestProcessBuilder {
    Map<String, String> additionalEnvironmentVariables = new ConcurrentHashMap<String, String>();
    private final NodeJsBinary nodeJsBinary;
    private final NpmBinary npmBinary;
    private final YarnBinary yarnBinary;
    private final JavaBinary javaBinary;

    public TestProcessBuilder(NodeJsBinary nodeJsBinary, NpmBinary npmBinary, YarnBinary yarnBinary, JavaBinary javaBinary) {
        this.nodeJsBinary = nodeJsBinary;
        this.npmBinary = npmBinary;
        this.yarnBinary = yarnBinary;
        this.javaBinary = javaBinary;
    }

    public ProcessBuilder nodejsRun(Path workingDirectory, Map<String, String> environment, Path fileToRun, String[] options) {
        String[] cmd = this.createCommandNodejsRun(fileToRun, environment, options);
        return this.createProcessBuilder(workingDirectory, cmd, environment);
    }

    public ProcessBuilder npmRun(Path workingDirectory, Map<String, String> environment, String[] options) {
        String[] cmd = this.createCommandNpmRun(environment, options);
        return this.createProcessBuilder(workingDirectory, cmd, environment);
    }

    public ProcessBuilder yarnRun(Path workingDirectory, Map<String, String> environment, String[] options) {
        String[] cmd = this.createCommandYarnRun(environment, options);
        return this.createProcessBuilder(workingDirectory, cmd, environment);
    }

    public ProcessBuilder n4jscRun(Path workingDirectory, Map<String, String> environment, N4jscOptions options) {
        Binary.inheritNodeJsPathEnvVariable(environment);
        String[] cmd = this.createCommandN4jscRun(environment, options);
        return this.createProcessBuilder(workingDirectory, cmd, environment);
    }

    private String[] createCommandNodejsRun(Path fileToRun, Map<String, String> output_env, String[] options) {
        if (fileToRun == null) {
            throw new IllegalArgumentException("run configuration does not specify a file to run");
        }
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("-r");
        optionList.add("esm");
        optionList.add(fileToRun.toString());
        optionList.addAll(Arrays.asList(options));
        String[] cmdOptions = (String[])optionList.toArray(String[]::new);
        List<String> cmd = this.getCommands(output_env, this.nodeJsBinary.getBinaryAbsolutePath(), cmdOptions);
        return cmd.toArray(new String[0]);
    }

    private String[] createCommandNpmRun(Map<String, String> output_env, String[] options) {
        List<String> cmd = this.getCommands(output_env, this.npmBinary.getBinaryAbsolutePath(), options);
        return cmd.toArray(new String[0]);
    }

    private String[] createCommandYarnRun(Map<String, String> output_env, String[] options) {
        List<String> cmd = this.getCommands(output_env, this.yarnBinary.getBinaryAbsolutePath(), options);
        return cmd.toArray(new String[0]);
    }

    private String[] createCommandN4jscRun(Map<String, String> output_env, N4jscOptions options) {
        File n4jscAbsoluteFile = new File("target/n4jsc.jar").getAbsoluteFile();
        String n4jscFileName = n4jscAbsoluteFile.toString();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("-jar");
        optionList.add(n4jscFileName);
        optionList.addAll(options.toArgs());
        String[] cmdOptions = (String[])optionList.toArray(String[]::new);
        List<String> cmd = this.getCommands(output_env, this.javaBinary.getBinaryAbsolutePath(), cmdOptions);
        return cmd.toArray(new String[0]);
    }

    private List<String> getCommands(Map<String, String> output_env, String binaryFileName, String ... options) {
        File binaryFile = new File(binaryFileName);
        String additionalPath = binaryFile.getParent();
        output_env.put("PATH", additionalPath);
        ArrayList<String> cmd = new ArrayList<String>();
        String npmPath = "\"" + binaryFileName + "\"";
        if (OSInfo.isWindows()) {
            cmd.addAll(Arrays.asList(NodeYarnProcessBuilder.WIN_SHELL_COMAMNDS));
            cmd.add(npmPath);
            cmd.addAll(Arrays.asList(options));
        } else {
            cmd.addAll(Arrays.asList(NodeYarnProcessBuilder.NIX_SHELL_COMAMNDS));
            cmd.add(String.valueOf(npmPath) + " " + String.join((CharSequence)" ", options));
        }
        return cmd;
    }

    private ProcessBuilder createProcessBuilder(Path workingDirectory, String[] cmd, Map<String, String> env) {
        IStatus status = this.nodeJsBinary.validate();
        if (!status.isOK()) {
            throw new IllegalStateException(status.getMessage());
        }
        if (workingDirectory == null) {
            throw new IllegalArgumentException("run configuration does not specify a working directory");
        }
        env.putAll(this.additionalEnvironmentVariables);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Map<String, String> environment = pb.environment();
        Binary.mergeEnvironments(environment, env);
        pb.directory(workingDirectory.toFile());
        return pb;
    }
}

