/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.util;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.xpect.util.ClasspathUtil;
import org.eclipse.xpect.util.IJavaReflectAccess;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.ClassMirror;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeMirror;
import org.eclipse.xtext.common.types.util.JavaReflectAccess;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class UIJavaReflectAccess
implements IJavaReflectAccess {
    private static final Logger LOG = Logger.getLogger(UIJavaReflectAccess.class);

    private Bundle getBundle(ClassMirror mirror) {
        Class mirroredClass = mirror.getMirroredClass();
        return FrameworkUtil.getBundle((Class)mirroredClass);
    }

    private Bundle getBundle(JdtTypeMirror mirror) {
        String bundleName;
        IType mirroredType = mirror.getMirroredType();
        IPackageFragmentRoot fragmentRoot = this.getPackageFragmentRoot((IJavaElement)mirroredType);
        if (fragmentRoot == null || fragmentRoot.getPath() == null) {
            return null;
        }
        File file = fragmentRoot.getPath().toFile();
        if (file.isFile()) {
            bundleName = this.getBundleNameFromJar(file);
        } else if (file.isDirectory()) {
            bundleName = this.getBundleNameFromDir(file);
        } else {
            return null;
        }
        if (bundleName == null) {
            return null;
        }
        return Platform.getBundle((String)bundleName);
    }

    private String getBundleNameFromDir(File file) {
        File current = file;
        int counter = 5;
        while (current != null && counter > 0) {
            File cand = new File(current + "/META-INF/MANIFEST.MF");
            if (cand.isFile()) {
                try {
                    return ClasspathUtil.getSymbolicName((InputStream)new FileInputStream(cand));
                }
                catch (FileNotFoundException e) {
                    LOG.error((Object)("Can't get symbolic name from " + cand), (Throwable)e);
                    return null;
                }
            }
            current = current.getParentFile();
        }
        return null;
    }

    private String getBundleNameFromJar(File file) {
        String string;
        JarFile jarFile = new JarFile(file);
        try {
            string = ClasspathUtil.getSymbolicName((Manifest)jarFile.getManifest());
        }
        catch (IOException e) {
            try {
                LOG.error((Object)("Can't get symbolic name from " + file), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close((Closeable)jarFile, (boolean)true);
                    throw throwable;
                }
                catch (IOException e1) {
                    LOG.error((Object)("Can't get symbolic name from " + file), (Throwable)e1);
                    return null;
                }
            }
            Closeables.close((Closeable)jarFile, (boolean)true);
            return null;
        }
        Closeables.close((Closeable)jarFile, (boolean)true);
        return string;
    }

    public Field getField(JvmField field) {
        Class<?> rawType = this.getRawType((JvmType)field.getDeclaringType());
        if (rawType == null) {
            return null;
        }
        try {
            return rawType.getDeclaredField(field.getSimpleName());
        }
        catch (Exception e) {
            LOG.error((Object)("Can't find " + field.getIdentifier()), (Throwable)e);
            return null;
        }
    }

    public Method getMethod(JvmOperation operation) {
        Class<?> rawType = this.getRawType((JvmType)operation.getDeclaringType());
        if (rawType == null) {
            return null;
        }
        Class<?>[] paramTypes = this.getParamTypes((JvmExecutable)operation);
        try {
            return rawType.getDeclaredMethod(operation.getSimpleName(), paramTypes);
        }
        catch (Exception e) {
            LOG.error((Object)("Can't find " + operation.getIdentifier()), (Throwable)e);
            return null;
        }
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaElement ele) {
        IJavaElement current = ele;
        while (current != null) {
            if (current instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)current;
            }
            current = current.getParent();
        }
        return null;
    }

    private Class<?>[] getParamTypes(JvmExecutable exe) {
        EList parameters = exe.getParameters();
        ArrayList result = Lists.newArrayList();
        for (JvmFormalParameter p : parameters) {
            result.add(this.getRawType(p.getParameterType().getType()));
        }
        return result.toArray(new Class[result.size()]);
    }

    public Class<?> getRawType(JvmType jvmType) {
        if (jvmType == null || jvmType.eIsProxy()) {
            return null;
        }
        XtextResourceSet resourceSet = (XtextResourceSet)jvmType.eResource().getResourceSet();
        if (resourceSet.getClasspathURIContext() instanceof ClassLoader) {
            JavaReflectAccess access = new JavaReflectAccess();
            access.setClassLoader((ClassLoader)resourceSet.getClasspathURIContext());
            return access.getRawType(jvmType);
        }
        if (!(jvmType.eResource() instanceof TypeResource)) {
            return null;
        }
        IMirror typeMirror = ((TypeResource)jvmType.eResource()).getMirror();
        Bundle bundle = null;
        if (typeMirror instanceof JdtTypeMirror) {
            bundle = this.getBundle((JdtTypeMirror)typeMirror);
        }
        if (typeMirror instanceof ClassMirror) {
            bundle = this.getBundle((ClassMirror)typeMirror);
        }
        if (bundle == null) {
            return null;
        }
        String className = jvmType.getQualifiedName();
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Could not find Java class for " + jvmType.eClass().getName() + " " + jvmType.getIdentifier()), (Throwable)e);
            return null;
        }
    }
}

