/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class RepositorySelection {
    private URIish uri;
    private RemoteConfig config;
    static final RepositorySelection INVALID_SELECTION = new RepositorySelection(null, null);

    public RepositorySelection(URIish uri, RemoteConfig config) {
        if (config != null && uri != null) {
            throw new IllegalArgumentException("URI and config cannot be set at the same time.");
        }
        this.config = config;
        this.uri = uri;
    }

    public URIish getURI(boolean pushMode) {
        if (this.isConfigSelected()) {
            if (pushMode) {
                if (this.config.getPushURIs().size() > 0) {
                    return (URIish)this.config.getPushURIs().get(0);
                }
                if (this.config.getURIs().size() > 0) {
                    return (URIish)this.config.getURIs().get(0);
                }
                return null;
            }
            if (this.config.getURIs().size() > 0) {
                return (URIish)this.config.getURIs().get(0);
            }
            if (this.config.getPushURIs().size() > 0) {
                return (URIish)this.config.getPushURIs().get(0);
            }
            return null;
        }
        return this.uri;
    }

    public URIish getURI() {
        if (this.isConfigSelected()) {
            return null;
        }
        return this.uri;
    }

    public List<URIish> getPushURIs() {
        if (this.isURISelected()) {
            return Collections.singletonList(this.uri);
        }
        if (this.isConfigSelected()) {
            ArrayList<URIish> pushUris = new ArrayList<URIish>();
            pushUris.addAll(this.config.getPushURIs());
            if (pushUris.isEmpty()) {
                pushUris.add((URIish)this.config.getURIs().get(0));
            }
            return pushUris;
        }
        return null;
    }

    public RemoteConfig getConfig() {
        return this.config;
    }

    public String getConfigName() {
        if (this.isConfigSelected()) {
            return this.config.getName();
        }
        return null;
    }

    public boolean isValidSelection() {
        return this.uri != null || this.config != null;
    }

    public boolean isURISelected() {
        return this.uri != null;
    }

    public boolean isConfigSelected() {
        return this.config != null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RepositorySelection) {
            RepositorySelection other = (RepositorySelection)obj;
            if (this.uri == null ^ other.uri == null) {
                return false;
            }
            if (this.uri != null && !this.uri.equals((Object)other.uri)) {
                return false;
            }
            return this.config == other.config;
        }
        return false;
    }

    public int hashCode() {
        if (this.uri != null) {
            return this.uri.hashCode();
        }
        if (this.config != null) {
            return this.config.hashCode();
        }
        return 31;
    }
}

