/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class LauncherUtils {
    public static final int WORKSPACE_LOCKED = 2000;
    public static final int CLEAR_LOG = 2001;
    public static final int DELETE_WORKSPACE = 2002;
    public static final int GENERATE_CONFIG_INI = 2003;
    public static final int ORGANIZE_MANIFESTS = 2004;
    public static final int SELECT_WORKSPACE_FIELD = 2005;
    private static final String TIMESTAMP = "timestamp";
    private static final String FILE_NAME = "dep-timestamp.properties";
    private static Properties fLastRun;
    private static String fLastLaunchMode;

    public static boolean clearWorkspace(ILaunchConfiguration configuration, String workspace, IProgressMonitor monitor) throws CoreException {
        if (workspace == null || workspace.length() == 0) {
            if (monitor != null) {
                monitor.done();
            }
            return true;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean isLocked = false;
        try {
            Object service;
            BundleContext context = PDECore.getDefault().getBundleContext();
            ServiceReference[] references = context.getServiceReferences(Location.class.getName(), "(type=osgi.configuration.area)");
            if (references.length > 0 && (service = context.getService(references[0])) instanceof Location) {
                URL workspaceURL = new Path(workspace).toFile().toURI().toURL();
                Location targetLocation = ((Location)service).createLocation(null, workspaceURL, false);
                targetLocation.set(targetLocation.getDefault(), false);
                isLocked = targetLocation.isLocked();
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            PDECore.log((Throwable)e);
            isLocked = false;
        }
        subMon.setWorkRemaining(90);
        if (subMon.isCanceled()) {
            return false;
        }
        if (isLocked) {
            Status status = new Status(4, "org.eclipse.pde.launching", 2000, null, null);
            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (statusHandler != null) {
                statusHandler.handleStatus((IStatus)status, (Object)new Object[]{workspace, configuration, fLastLaunchMode});
            }
            subMon.done();
            if (monitor != null) {
                monitor.done();
            }
            return false;
        }
        File workspaceFile = new Path(workspace).toFile().getAbsoluteFile();
        if (configuration.getAttribute("clearws", false) && workspaceFile.exists()) {
            if (configuration.getAttribute("askclear", true)) {
                IStatusHandler statusHandler;
                Status status;
                int result = 0;
                if (configuration.getAttribute("clearwslog", false)) {
                    status = new Status(4, "org.eclipse.pde.launching", 2001, null, null);
                    statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                    if (statusHandler != null) {
                        result = (Integer)statusHandler.handleStatus((IStatus)status, null);
                    }
                } else {
                    status = new Status(4, "org.eclipse.pde.launching", 2002, null, null);
                    statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                    if (statusHandler != null) {
                        result = (Integer)statusHandler.handleStatus((IStatus)status, (Object)workspaceFile.getPath());
                    }
                }
                if (result == 2 || result == -1) {
                    subMon.done();
                    if (monitor != null) {
                        monitor.done();
                    }
                    return false;
                }
                if (result == 0) {
                    if (configuration.getAttribute("clearwslog", false)) {
                        LauncherUtils.clearWorkspaceLog(workspace);
                    } else {
                        CoreUtility.deleteContent((File)workspaceFile, (IProgressMonitor)subMon.split(90));
                    }
                }
            } else if (configuration.getAttribute("clearwslog", false)) {
                LauncherUtils.clearWorkspaceLog(workspace);
            } else {
                CoreUtility.deleteContent((File)workspaceFile, (IProgressMonitor)subMon.split(90));
            }
        }
        if (subMon.isCanceled()) {
            return false;
        }
        subMon.done();
        if (monitor != null) {
            monitor.done();
        }
        return true;
    }

    public static boolean generateConfigIni() throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.launching", 2003, null, null);
        IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        return statusHandler == null ? true : (Boolean)statusHandler.handleStatus((IStatus)status, null);
    }

    public static void validateProjectDependencies(ILaunchConfiguration launch, IProgressMonitor monitor) {
        PDEPreferencesManager store = PDELaunchingPlugin.getDefault().getPreferenceManager();
        if (!store.getBoolean("Preferences.MainPage.automanageDependencies")) {
            return;
        }
        try {
            String timeStamp = launch.getAttribute(TIMESTAMP, "0");
            boolean autoAdd = launch.getAttribute("automaticAdd", true);
            boolean useDefault = launch.getAttribute("default", true);
            ArrayList<IProject> projects = new ArrayList<IProject>();
            if (useDefault) {
                LauncherUtils.handleUseDefault(timeStamp, projects);
            } else if (autoAdd) {
                LauncherUtils.handleDeselectedPlugins(launch, timeStamp, projects);
            } else {
                LauncherUtils.handleSelectedPlugins(launch, timeStamp, projects);
            }
            if (!projects.isEmpty()) {
                Status status = new Status(4, "org.eclipse.pde.launching", 2004, null, null);
                IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (statusHandler != null) {
                    statusHandler.handleStatus((IStatus)status, (Object)new Object[]{projects, monitor, LauncherUtils.getLastRun()});
                }
                ILaunchConfigurationWorkingCopy wc = null;
                wc = launch.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)launch : launch.getWorkingCopy();
                wc.setAttribute(TIMESTAMP, Long.toString(System.currentTimeMillis()));
                wc.doSave();
            }
        }
        catch (CoreException coreException) {}
    }

    private static String getTimeStamp(IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            IFile[] otherFiles;
            IClasspathEntry[] entries;
            long timeStamp = 0L;
            IClasspathEntry[] iClasspathEntryArray = entries = jp.getResolvedClasspath(true);
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entrie = iClasspathEntryArray[n2];
                if (entrie.getEntryKind() == 3) {
                    IResource res;
                    IPath path;
                    IPath location = entrie.getOutputLocation();
                    if (location == null) {
                        location = jp.getOutputLocation();
                    }
                    IPath iPath = path = (res = project.getWorkspace().getRoot().findMember(location)) == null ? null : res.getLocation();
                    if (path != null) {
                        File file = path.toFile();
                        ArrayDeque<File> files = new ArrayDeque<File>();
                        files.push(file);
                        while (!files.isEmpty()) {
                            file = (File)files.pop();
                            if (file.isDirectory()) {
                                File[] children = file.listFiles();
                                if (children == null) continue;
                                File[] fileArray = children;
                                int n3 = children.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    File element = fileArray[n4];
                                    files.push(element);
                                    ++n4;
                                }
                                continue;
                            }
                            if (!file.getName().endsWith(".class") || timeStamp >= file.lastModified()) continue;
                            timeStamp = file.lastModified();
                        }
                    }
                }
                ++n2;
            }
            IFile[] iFileArray = otherFiles = new IFile[]{PDEProject.getManifest((IProject)project), PDEProject.getBuildProperties((IProject)project)};
            int n5 = otherFiles.length;
            n = 0;
            while (n < n5) {
                long fileTimeStamp;
                IFile file = iFileArray[n];
                if (file != null && timeStamp < (fileTimeStamp = file.getRawLocation().toFile().lastModified())) {
                    timeStamp = fileTimeStamp;
                }
                ++n;
            }
            return Long.toString(timeStamp);
        }
        catch (JavaModelException javaModelException) {
            return "0";
        }
    }

    private static void handleUseDefault(String launcherTimeStamp, ArrayList<IProject> projects) {
        IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projs.length) {
            String timestamp;
            if (WorkspaceModelManager.isPluginProject((IProject)projs[i]) && (timestamp = LauncherUtils.getTimeStamp(projs[i])).compareTo(launcherTimeStamp) > 0 && LauncherUtils.shouldAdd(projs[i], launcherTimeStamp, timestamp)) {
                projects.add(projs[i]);
            }
            ++i;
        }
    }

    private static void handleSelectedPlugins(ILaunchConfiguration config, String timeStamp, ArrayList<IProject> projects) throws CoreException {
        Map<IPluginModelBase, String> selectedPlugins = BundleLauncherHelper.getWorkspaceBundleMap(config, null, "selected_workspace_plugins");
        for (IPluginModelBase model : selectedPlugins.keySet()) {
            IProject project;
            String projTimeStamp;
            IResource res = model.getUnderlyingResource();
            if (res == null || (projTimeStamp = LauncherUtils.getTimeStamp(project = res.getProject())).compareTo(timeStamp) <= 0 || !LauncherUtils.shouldAdd(project, timeStamp, projTimeStamp)) continue;
            projects.add(project);
        }
    }

    private static void handleDeselectedPlugins(ILaunchConfiguration config, String launcherTimeStamp, ArrayList<IProject> projects) throws CoreException {
        Map<IPluginModelBase, String> deSelectedPlugins = BundleLauncherHelper.getWorkspaceBundleMap(config, null, "deselected_workspace_plugins");
        IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projs.length) {
            String timestamp;
            IPluginModelBase base;
            if (WorkspaceModelManager.isPluginProject((IProject)projs[i]) && (base = PluginRegistry.findModel((IProject)projs[i])) != null && !deSelectedPlugins.containsKey(base) && (timestamp = LauncherUtils.getTimeStamp(projs[i])).compareTo(launcherTimeStamp) > 0 && LauncherUtils.shouldAdd(projs[i], launcherTimeStamp, timestamp)) {
                projects.add(projs[i]);
            }
            ++i;
        }
    }

    public static final void shutdown() {
        if (fLastRun == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var1_3 = null;
            try (FileOutputStream stream = new FileOutputStream(new File(LauncherUtils.getDirectory(), FILE_NAME));){
                fLastRun.store(stream, "Cached timestamps");
                stream.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException((Throwable)e);
        }
    }

    private static File getDirectory() {
        IPath path = PDECore.getDefault().getStateLocation().append(".cache");
        File directory = new File(path.toOSString());
        if (!directory.exists() || !directory.isDirectory()) {
            directory.mkdirs();
        }
        return directory;
    }

    private static Properties getLastRun() {
        block12: {
            if (fLastRun == null) {
                fLastRun = new Properties();
                try {
                    File file = new File(LauncherUtils.getDirectory(), FILE_NAME);
                    if (!file.exists()) break block12;
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (FileInputStream fis = new FileInputStream(file);){
                        fLastRun.load(fis);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    PDECore.logException((Throwable)e);
                }
            }
        }
        return fLastRun;
    }

    private static boolean shouldAdd(IProject proj, String launcherTS, String fileSystemTS) {
        String projTS = (String)LauncherUtils.getLastRun().get(proj.getName());
        if (projTS == null) {
            return true;
        }
        return projTS.compareTo(launcherTS) < 0 || projTS.compareTo(fileSystemTS) < 0;
    }

    public static boolean requiresUI(ILaunchConfiguration configuration) {
        try {
            IPluginModelBase model;
            IResource project;
            String projectID = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            if (projectID.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().findMember(projectID)) instanceof IProject && (model = PluginRegistry.findModel((IProject)((IProject)project))) != null) {
                Set plugins = DependencyManager.getSelfAndDependencies((IPluginModelBase)model, null);
                return plugins.contains("org.eclipse.swt");
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    public static boolean clearWorkspaceLog(String workspace) {
        File logFile = new File(workspace, ".metadata" + File.separator + ".log");
        if (logFile.exists()) {
            return logFile.delete();
        }
        return true;
    }

    public static IStatus createErrorStatus(String message) {
        return new Status(4, PDELaunchingPlugin.getPluginId(), 0, message, null);
    }

    public static void setLastLaunchMode(String launchMode) {
        fLastLaunchMode = launchMode;
    }
}

