/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.validation;

import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.ide.server.ReflectionUtils;
import org.eclipse.n4js.ide.validation.N4JSIssue;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.LineAndColumn;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.DiagnosticConverterImpl;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.RangeBasedDiagnostic;

public class N4JSDiagnosticConverter
extends DiagnosticConverterImpl {
    public void convertResourceDiagnostic(Resource.Diagnostic diagnostic, Severity severity, IAcceptor<Issue> acceptor) {
        N4JSIssue issue = new N4JSIssue();
        issue.setSyntaxError(diagnostic instanceof XtextSyntaxDiagnostic);
        issue.setSeverity(severity);
        issue.setLineNumber(diagnostic.getLine() - 1);
        issue.setColumn(diagnostic.getColumn() - 1);
        issue.setMessage(diagnostic.getMessage());
        if (diagnostic instanceof org.eclipse.xtext.diagnostics.Diagnostic) {
            org.eclipse.xtext.diagnostics.Diagnostic xtextDiagnostic = (org.eclipse.xtext.diagnostics.Diagnostic)diagnostic;
            issue.setOffset(xtextDiagnostic.getOffset());
            issue.setLength(xtextDiagnostic.getLength());
        }
        if (diagnostic instanceof AbstractDiagnostic) {
            AbstractDiagnostic castedDiagnostic = (AbstractDiagnostic)diagnostic;
            issue.setUriToProblem(castedDiagnostic.getUriToProblem());
            issue.setCode(castedDiagnostic.getCode());
            issue.setData(castedDiagnostic.getData());
            INode node = (INode)ReflectionUtils.getMethodReturn(AbstractDiagnostic.class, "getNode", diagnostic);
            int posEnd = castedDiagnostic.getOffset() + castedDiagnostic.getLength();
            LineAndColumn lineAndColumn = NodeModelUtils.getLineAndColumn((INode)node, (int)posEnd);
            issue.setLineNumberEnd(lineAndColumn.getLine() - 1);
            issue.setColumnEnd(lineAndColumn.getColumn() - 1);
        }
        issue.setType(CheckType.FAST);
        acceptor.accept((Object)issue);
    }

    public void convertValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
        EObject causer;
        N4JSIssue issue = new N4JSIssue();
        Severity severity = this.getSeverity(diagnostic);
        if (severity == null) {
            return;
        }
        issue.setSeverity(severity);
        DiagnosticConverterImpl.IssueLocation locationData = this.getLocationData(diagnostic);
        if (locationData != null) {
            issue.setLineNumber(locationData.lineNumber);
            issue.setColumn(locationData.column);
            issue.setOffset(locationData.offset);
            issue.setLength(locationData.length);
            if (locationData instanceof N4JSIssueLocation) {
                N4JSIssueLocation n4jsLocationData = (N4JSIssueLocation)locationData;
                issue.setLineNumberEnd(n4jsLocationData.lineNumberEnd);
                issue.setColumnEnd(n4jsLocationData.columnEnd);
            }
        }
        if ((causer = this.getCauser(diagnostic)) != null) {
            issue.setUriToProblem(EcoreUtil.getURI((EObject)causer));
        } else {
            for (Object obj : diagnostic.getData()) {
                if (!(obj instanceof URI)) continue;
                issue.setUriToProblem((URI)obj);
            }
        }
        issue.setCode(this.getIssueCode(diagnostic));
        issue.setType(this.getIssueType(diagnostic));
        issue.setData(this.getIssueData(diagnostic));
        issue.setMessage(diagnostic.getMessage());
        acceptor.accept((Object)issue);
    }

    protected DiagnosticConverterImpl.IssueLocation getLocationData(Diagnostic diagnostic) {
        EObject causer = this.getCauser(diagnostic);
        if (causer != null) {
            if (diagnostic instanceof RangeBasedDiagnostic) {
                RangeBasedDiagnostic castedDiagnostic = (RangeBasedDiagnostic)diagnostic;
                ICompositeNode parserNode = NodeModelUtils.getNode((EObject)causer);
                N4JSIssueLocation result = new N4JSIssueLocation();
                if (parserNode != null) {
                    LineAndColumn lineAndColumnStart = NodeModelUtils.getLineAndColumn((INode)parserNode, (int)castedDiagnostic.getOffset());
                    result.lineNumber = lineAndColumnStart.getLine() - 1;
                    result.column = lineAndColumnStart.getColumn() - 1;
                    LineAndColumn lineAndColumnEnd = NodeModelUtils.getLineAndColumn((INode)parserNode, (int)(castedDiagnostic.getOffset() + castedDiagnostic.getLength()));
                    result.lineNumberEnd = lineAndColumnEnd.getLine() - 1;
                    result.columnEnd = lineAndColumnEnd.getColumn() - 1;
                }
                result.offset = castedDiagnostic.getOffset();
                result.length = castedDiagnostic.getLength();
                return result;
            }
            if (diagnostic instanceof FeatureBasedDiagnostic) {
                FeatureBasedDiagnostic castedDiagnostic = (FeatureBasedDiagnostic)diagnostic;
                return this.getLocationData(causer, castedDiagnostic.getFeature(), castedDiagnostic.getIndex());
            }
            List data = diagnostic.getData();
            Object feature = data.size() > 1 ? data.get(1) : null;
            EStructuralFeature structuralFeature = this.resolveStructuralFeature(causer, feature);
            return this.getLocationData(causer, structuralFeature, 0);
        }
        return null;
    }

    protected DiagnosticConverterImpl.IssueLocation getLocationForNode(INode node) {
        ITextRegionWithLineInformation nodeRegion = node.getTextRegionWithLineInformation();
        N4JSIssueLocation result = new N4JSIssueLocation();
        result.offset = nodeRegion.getOffset();
        result.length = nodeRegion.getLength();
        LineAndColumn lineAndColumnStart = NodeModelUtils.getLineAndColumn((INode)node, (int)result.offset);
        result.lineNumber = lineAndColumnStart.getLine() - 1;
        result.column = lineAndColumnStart.getColumn() - 1;
        LineAndColumn lineAndColumnEnd = NodeModelUtils.getLineAndColumn((INode)node, (int)(result.offset + result.length));
        result.lineNumberEnd = lineAndColumnEnd.getLine() - 1;
        result.columnEnd = lineAndColumnEnd.getColumn() - 1;
        return result;
    }

    static class N4JSIssueLocation
    extends DiagnosticConverterImpl.IssueLocation {
        int lineNumberEnd;
        int columnEnd;

        N4JSIssueLocation() {
        }
    }
}

