/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import java.util.Objects;
import java.util.function.Supplier;

public class Lazy<T> {
    private volatile T value;
    private volatile boolean initialized = false;
    private volatile Supplier<T> supplier;

    public static <T> Lazy<T> create(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    public Lazy(Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public T get() {
        return this.initialized ? this.value : this.compute();
    }

    private synchronized T compute() {
        if (!this.initialized) {
            this.value = this.supplier.get();
            this.initialized = true;
            this.supplier = null;
        }
        return this.value;
    }
}

