/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.n4js.xpect.ui.results.ExecutionStatus;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class ExecutionResults {
    Map<Description, ExecutionStatus> allStatuses = new HashMap<Description, ExecutionStatus>();
    Map<Description, Failure> allFailures = new HashMap<Description, Failure>();
    Map<Description, Description> parents = new HashMap<Description, Description>();

    public void initResults(Description desc) {
        this.allStatuses.clear();
        this.allFailures.clear();
        this.parents.clear();
        this.collectStatusesAndParents(desc);
    }

    private void collectStatusesAndParents(Description description) {
        this.allStatuses.put(description, ExecutionStatus.PENDING);
        description.getChildren().forEach(childDescription -> {
            this.allStatuses.put((Description)childDescription, ExecutionStatus.PENDING);
            this.parents.put((Description)childDescription, description);
            this.collectStatusesAndParents((Description)childDescription);
        });
    }

    public ExecutionStatus getStatus(Description description) {
        return this.allStatuses.get(description);
    }

    private void updateParents(Description description, ExecutionStatus status) {
        Description parent = this.parents.get(description);
        if (parent != null) {
            if (status.equals((Object)ExecutionStatus.FAILED)) {
                this.allStatuses.put(parent, status);
                this.updateParents(parent, status);
            } else {
                boolean allChildrenFinished = parent.getChildren().stream().map(desc -> this.allStatuses.get(desc)).noneMatch(st -> st.equals((Object)ExecutionStatus.PENDING));
                if (allChildrenFinished) {
                    boolean noBrokenChildren = parent.getChildren().stream().map(desc -> this.allStatuses.get(desc)).noneMatch(st -> st.equals((Object)ExecutionStatus.FAILED));
                    if (noBrokenChildren) {
                        this.allStatuses.put(parent, ExecutionStatus.PASSED);
                        this.updateParents(parent, ExecutionStatus.PASSED);
                    } else {
                        this.allStatuses.put(parent, ExecutionStatus.FAILED);
                        this.updateParents(parent, ExecutionStatus.FAILED);
                    }
                }
            }
        }
    }

    public void executionFailed(Failure failure) {
        Description description = failure.getDescription();
        this.allStatuses.put(description, ExecutionStatus.FAILED);
        this.allFailures.put(description, failure);
        this.updateParents(description, ExecutionStatus.FAILED);
    }

    public void executionStarted(Description description) {
        this.allStatuses.put(description, ExecutionStatus.STARTED);
        this.updateParents(description, ExecutionStatus.STARTED);
    }

    public void executionIgnored(Description description) {
        this.allStatuses.put(description, ExecutionStatus.IGNORED);
        this.updateParents(description, ExecutionStatus.IGNORED);
    }

    public void testPassed(Description description) {
        this.allStatuses.put(description, ExecutionStatus.PASSED);
        this.updateParents(description, ExecutionStatus.PASSED);
    }

    public boolean hasFailed(Description description) {
        return this.allFailures.containsKey(description);
    }

    public Failure getFailure(Description description) {
        return this.allFailures.get(description);
    }
}

