/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.refactoring;

import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.internal.core.debug.mwe.ReflectionUtil;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.tests.util.EclipseGracefulUIShutdownEnabler;
import org.eclipse.n4js.tests.util.EditorsUtil;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.n4js.xpect.common.XpectCommentRemovalUtil;
import org.eclipse.n4js.xpect.config.Config;
import org.eclipse.n4js.xpect.config.VarDef;
import org.eclipse.n4js.xpect.config.XpEnvironmentData;
import org.eclipse.n4js.xpect.methods.scoping.IN4JSCommaSeparatedValuesExpectation;
import org.eclipse.n4js.xpect.methods.scoping.N4JSCommaSeparatedValuesExpectation;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringDiffExpectation;
import org.eclipse.xpect.expectation.StringDiffExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestModuleSetup;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameContextFactory;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.IRenameSupport;

@XpectImport(value={N4JSOffsetAdapter.class, XpEnvironmentData.class, VarDef.class, Config.class, ValidationTestModuleSetup.class})
public class RenameRefactoringXpectMethod {
    @Inject
    private IRenameSupport.Factory renameSupportFactory;
    @Inject
    private EObjectAtOffsetHelper offsetHelper;
    @Inject
    private IRenameContextFactory renameContextFactory;

    static {
        EclipseGracefulUIShutdownEnabler.enableOnce();
    }

    @ParameterParser(syntax="('at' arg2=OFFSET 'to' arg3=STRING) ('resource' arg4=STRING)?")
    @Xpect
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void renameRefactoring(@StringDiffExpectation(whitespaceSensitive=false) IStringDiffExpectation expectation, @ThisResource XtextResource resource, N4JSOffsetAdapter.IEObjectCoveringRegion offset, String newName, String specifiedResourcePath, @N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectedResult) throws Exception {
        try {
            ITextSelection selection;
            URI targetResourceUri;
            Optional editorOp;
            XtextEditor editor;
            IRenameElementContext renameElementContext;
            IRenameSupport renameSupport;
            ProcessorBasedRefactoring refactoring;
            RefactoringStatus status;
            EObject context = offset.getEObject();
            EObject selectedElement = this.offsetHelper.resolveElementAt((XtextResource)context.eResource(), offset.getOffset());
            if (selectedElement instanceof LiteralOrComputedPropertyName) {
                selectedElement = selectedElement.eContainer();
            }
            if (!(selectedElement instanceof FormalParameter) && N4JSLanguageUtils.getDefinedTypeModelElement((EObject)selectedElement) != null) {
                selectedElement = N4JSLanguageUtils.getDefinedTypeModelElement((EObject)selectedElement);
            }
            if ((status = (refactoring = (ProcessorBasedRefactoring)ReflectionUtil.getFieldValue((Object)(renameSupport = this.renameSupportFactory.create((Object)(renameElementContext = this.renameContextFactory.createRenameElementContext(selectedElement, editor = (XtextEditor)(editorOp = EditorsUtil.openXtextEditor((URI)(targetResourceUri = context.eResource().getURI()), (String)"org.eclipse.n4js.N4JS")).get(), selection = (ITextSelection)editor.getSelectionProvider().getSelection(), resource)), newName)), (String)"renameRefactoring")).checkAllConditions((IProgressMonitor)new NullProgressMonitor())).hasError()) {
                RefactoringStatusEntry[] entries = status.getEntries();
                List errorMessages = Arrays.stream(entries).map(statusEntry -> statusEntry.getMessage()).collect(Collectors.toList());
                expectedResult.assertEquals(errorMessages);
            } else {
                String beforeRenameContent = this.getResourceContentWithoutXpectComment(specifiedResourcePath, resource);
                renameSupport.startDirectRefactoring();
                String afterRenameContent = this.getResourceContentWithoutXpectComment(specifiedResourcePath, resource);
                expectation.assertDiffEquals(beforeRenameContent, afterRenameContent);
            }
        }
        finally {
            EditorsUtil.forceCloseAllEditors();
        }
    }

    private String getResourceContentWithoutXpectComment(String specifiedResourcePath, XtextResource resource) throws Exception {
        if (specifiedResourcePath != null && !specifiedResourcePath.isEmpty()) {
            URI specifiedURI = resource.getURI().trimSegments(1).appendSegments(specifiedResourcePath.split("/"));
            return XpectCommentRemovalUtil.removeAllXpectComments((String)this.getContentForResourceUri(specifiedURI));
        }
        return XpectCommentRemovalUtil.removeAllXpectComments((String)this.getContentForResourceUri(resource.getURI()));
    }

    private String getContentForResourceUri(URI uri) throws Exception {
        String platformStr = uri.toString().replace("platform:/resource/", "");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformStr));
        InputStream fileStream = file.getContents();
        Scanner s = new Scanner(fileStream, file.getCharset());
        s.useDelimiter("\\A");
        String content = s.hasNext() ? s.next() : "";
        fileStream.close();
        s.close();
        return content;
    }
}

