/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.filechecker;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultimap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.n4js.filechecker.CRHStatsPrinter;
import org.eclipse.n4js.filechecker.FullReport;
import org.eclipse.n4js.filechecker.Report;

abstract class AbstractFileChecker {
    protected static final String[] DISREGARDED_FOLDERS = new String[]{".git", "bin"};
    protected static final String FILE_NAME__THIRD_PARTY = "third-party.txt";

    AbstractFileChecker() {
    }

    protected abstract String[] getRepos();

    protected abstract String[] getReposMandatory();

    protected abstract boolean isIgnored(Path var1, String var2);

    protected abstract void checkFile(Path var1, String var2, boolean var3, Report var4);

    protected abstract void checkFolder(Path var1, int var2, Report var3);

    protected Path[] findRepoPaths(String[] args) {
        String[] repoNames = this.getRepos();
        String[] repoNamesMandatory = this.getReposMandatory();
        Path rootPath = AbstractFileChecker.findRootPath(args, repoNames);
        String[] stringArray = repoNamesMandatory;
        int n = repoNamesMandatory.length;
        int n2 = 0;
        while (n2 < n) {
            String repoMandatory = stringArray[n2];
            if (!rootPath.resolve(repoMandatory).toFile().isDirectory()) {
                System.out.println("ERROR: root folder doesn't contain mandatory sub folder \"" + repoMandatory + "\"");
                System.exit(1);
            }
            ++n2;
        }
        Path[] repoPaths = (Path[])Arrays.asList(repoNames).stream().map(repoName -> rootPath.resolve((String)repoName)).toArray(Path[]::new);
        return repoPaths;
    }

    protected static Path findRootPath(String[] args, String[] repoNames) {
        Path rootPath = AbstractFileChecker.findRootPathFailSafe(args, repoNames);
        if (rootPath == null || !rootPath.toFile().exists() || !rootPath.toFile().isDirectory()) {
            System.out.println("ERROR: root path not found or does not point to a folder");
            System.out.println("Root path must either be given as first command line argument\nOR the current working directory must lie in an N4JS git repository.");
            System.exit(1);
        }
        return rootPath;
    }

    protected static Path findRootPathFailSafe(String[] args, String[] repoNames) {
        try {
            if (args.length > 0) {
                return new File(args[0]).getCanonicalFile().toPath();
            }
            File curr = new File(".").getCanonicalFile();
            while (curr != null && curr.isDirectory() && !AbstractFileChecker.containsSubDir(curr, repoNames)) {
                curr = curr.getParentFile();
            }
            return curr != null ? curr.toPath() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean containsSubDir(File dir, String[] subDirNames) {
        Object[] actualSubDirNames = dir.list();
        if (actualSubDirNames != null) {
            String[] stringArray = subDirNames;
            int n = subDirNames.length;
            int n2 = 0;
            while (n2 < n) {
                String subDirName = stringArray[n2];
                if (org.eclipse.xtext.util.Arrays.contains((Object[])actualSubDirNames, (Object)subDirName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean run(String[] args) {
        Path[] repoPaths = this.findRepoPaths(args);
        System.out.println("=====================================================================================");
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger ignored = new AtomicInteger(0);
        AtomicInteger checked = new AtomicInteger(0);
        AtomicInteger checkedThirdParty = new AtomicInteger(0);
        FullReport fullReport = new FullReport();
        try {
            this.walkFileTree(count, ignored, checked, checkedThirdParty, fullReport, repoPaths);
        }
        catch (IOException e) {
            System.out.println("ERROR while walking folder tree:");
            e.printStackTrace();
            System.out.println("ABORTING");
            return false;
        }
        System.out.println("-------------------------------------------------------------------------------------");
        if (fullReport.hasInvalidFiles()) {
            this.printInvalidFiles(fullReport);
        } else {
            System.out.println("No problems.");
        }
        if (fullReport.hasErroneousFiles()) {
            this.printErrors(fullReport.getErroneousFiles());
        }
        this.printResults(count, ignored, checked, checkedThirdParty, fullReport);
        CRHStatsPrinter.println(fullReport);
        boolean everythingOK = !fullReport.hasInvalidFiles() && !fullReport.hasErroneousFiles();
        return everythingOK;
    }

    private void walkFileTree(AtomicInteger count, AtomicInteger ignored, AtomicInteger checked, AtomicInteger checkedThirdParty, FullReport fullReport, Path ... repoPaths) throws IOException {
        Path[] pathArray = repoPaths;
        int n = repoPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Path repoPath = pathArray[n2];
            System.out.println("Asserting file integrity in " + repoPath);
            Set<Path> thirdPartyFiles = AbstractFileChecker.readListOfThirdPartyFiles(repoPath);
            System.out.print("Checking files ...");
            Files.walk(repoPath, new FileVisitOption[0]).forEachOrdered(path2 -> {
                File file = path2.toFile();
                String pathStr = AbstractFileChecker.getCanonicalPath(file);
                if (AbstractFileChecker.isBelowFolder(pathStr, DISREGARDED_FOLDERS)) {
                    return;
                }
                count.incrementAndGet();
                Report report = new Report((Path)path2);
                fullReport.addReport(report);
                if (this.isIgnored((Path)path2, pathStr)) {
                    ignored.incrementAndGet();
                    report.setToIgnored();
                } else {
                    checked.incrementAndGet();
                    try {
                        this.checkFile(checkedThirdParty, repoPath, thirdPartyFiles, report);
                    }
                    catch (Throwable th) {
                        report.setThrowable(th);
                    }
                }
            });
            System.out.println(" done.");
            ++n2;
        }
    }

    private void checkFile(AtomicInteger checkedThirdParty, Path repoPath, Set<Path> thirdPartyFiles, Report report) throws IOException {
        Path path = report.path;
        if (path.toFile().isDirectory()) {
            this.checkFolder(path, path.getNameCount() - repoPath.getNameCount(), report);
        } else {
            String content = AbstractFileChecker.readFile(path);
            boolean isThirdParty = thirdPartyFiles.contains(path);
            if (isThirdParty) {
                checkedThirdParty.incrementAndGet();
                report.setToThirdParty();
            }
            this.checkFile(path, content, isThirdParty, report);
        }
    }

    private void printInvalidFiles(FullReport fullReport) {
        LinkedHashMultimap pathsPerError = LinkedHashMultimap.create();
        for (Report report : fullReport.getInvalidReports()) {
            for (String err : report.problems) {
                pathsPerError.put((Object)err, (Object)report.path);
            }
        }
        ArrayList errors = new ArrayList(pathsPerError.keySet());
        Collections.sort(errors);
        for (String err : errors) {
            Collection paths = pathsPerError.get((Object)err);
            System.out.println("PROBLEM in " + paths.size() + " files: " + err);
            for (Path path : paths) {
                System.out.println("    " + path);
            }
        }
    }

    private void printErrors(Collection<Report> erroneousReports) {
        System.out.flush();
        AbstractFileChecker.sleep(500L);
        for (Report errReport : erroneousReports) {
            System.err.println("ERROR processing file: " + errReport.path);
            errReport.getError().printStackTrace();
        }
        System.err.flush();
        AbstractFileChecker.sleep(500L);
    }

    private void printResults(AtomicInteger count, AtomicInteger ignored, AtomicInteger checked, AtomicInteger checkedThirdParty, FullReport fullReport) {
        System.out.println("-------------------------------------------------------------------------------------");
        System.out.println("Checked " + checked + " files, including " + checkedThirdParty + " third-party files (" + ignored + " ignored; " + count + " total).");
        System.out.println("Valid files: " + fullReport.getValidReports().size());
        System.out.println("Invalid files: " + fullReport.getInvalidReports().size());
        System.out.println("Erroneous files: " + fullReport.getErroneousFiles().size());
        System.out.println("=====================================================================================");
    }

    private static Set<Path> readListOfThirdPartyFiles(Path rootPath) throws IOException {
        System.out.println("Reading list of third-party files from \"third-party.txt\" ...");
        Path thirdPartyList = rootPath.resolve(FILE_NAME__THIRD_PARTY);
        if (!thirdPartyList.toFile().exists()) {
            System.out.println("    no such file found, assuming 0 third-party files.");
            return Collections.emptySet();
        }
        List<String> lines = Files.readAllLines(thirdPartyList, StandardCharsets.UTF_8);
        lines.replaceAll(l -> l.trim());
        lines.removeIf(l -> l.length() == 0 || l.startsWith("#"));
        if (lines.stream().anyMatch(l -> l.startsWith("/") || l.startsWith("\\"))) {
            throw new IOException("paths in third-party.txt must be relative, i.e. not start with '/'");
        }
        List paths = lines.stream().map(l -> rootPath.resolve((String)l)).collect(Collectors.toList());
        int files = 0;
        int folders = 0;
        int i = 0;
        while (i < paths.size()) {
            Path p = (Path)paths.get(i);
            if (p.endsWith("**")) {
                Path parent = p.getParent();
                List<Path> allFiles = AbstractFileChecker.getAllContainedFiles(parent);
                allFiles.isEmpty();
                paths.remove(i);
                paths.addAll(i, allFiles);
                i += allFiles.size() - 1;
            }
            ++i;
        }
        Set duplicates = AbstractFileChecker.collectDuplicates(paths);
        if (!duplicates.isEmpty()) {
            throw new IOException("the following files are declared more than once in third-party.txt (maybe because they are contained in a folder declared with \"/**\"):\n    " + Joiner.on((String)"\n    ").join(duplicates));
        }
        System.out.println("    " + files + " files and " + folders + " folders (for a total of " + paths.size() + " files) declared as third-party artifacts.");
        return new HashSet<Path>(paths);
    }

    protected static int containsTrailingWhiteSpace(String str) {
        int lineNumber = 0;
        int idx = 0;
        while (idx < str.length()) {
            char ch;
            if ((idx = str.indexOf(10, idx)) < 0) break;
            ++lineNumber;
            char c = ch = idx > 0 ? (char)str.charAt(idx - 1) : (char)'X';
            if (ch == '\r') {
                char c2 = ch = idx > 1 ? str.charAt(idx - 2) : (char)'X';
            }
            if (ch != '\n' && Character.isWhitespace(ch)) {
                return lineNumber;
            }
            ++idx;
        }
        return -1;
    }

    protected static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected static boolean hasExtension(Path path, String ... extensions) {
        Path namePath = path.getFileName();
        if (namePath == null) {
            return false;
        }
        String name = namePath.toString();
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (name.endsWith(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean isFile(String pathStr, String ... fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (pathStr.endsWith("/" + fileName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean isBelowFolder(String pathStr, String ... folderNames) {
        String[] stringArray = folderNames;
        int n = folderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String folderName = stringArray[n2];
            if (pathStr.contains("/" + folderName + "/")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean inExtendedRepo(Path path) {
        return AbstractFileChecker.isBelowFolder(path.toString(), "n4js-extended");
    }

    protected boolean containsFileWithName(Path path, String fileName) {
        File file = path.toFile();
        File[] files = file.listFiles();
        return files != null && Stream.of(files).anyMatch(f -> fileName.equals(f.getName()));
    }

    protected boolean containsPattern(String str, Pattern pattern) {
        return pattern.matcher(str).find();
    }

    protected static String fixFileEnding(String content) {
        if (content.length() > 0) {
            int endIndex = content.length();
            while (endIndex > 0 && content.charAt(endIndex - 1) == '\n') {
                --endIndex;
            }
            content = String.valueOf(content.substring(0, endIndex)) + '\n';
        }
        return content;
    }

    protected static String trimTrailingWhiteSpace(String content) {
        return content.replaceAll("[ \\t\\x0B\\f\\r]+\\n", "\n");
    }

    protected static List<Path> getAllContainedFiles(Path path) throws IOException {
        if (!path.toFile().exists()) {
            return Collections.emptyList();
        }
        return Files.walk(path, new FileVisitOption[0]).filter(p -> p.toFile().isFile()).collect(Collectors.toList());
    }

    protected static String readFile(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    protected static void writeFile(Path path, String content) {
        try {
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T> Set<T> collectDuplicates(Collection<? extends T> coll) {
        LinkedHashSet<T> duplicates = new LinkedHashSet<T>();
        HashSet<T> seen = new HashSet<T>();
        for (T p : coll) {
            if (seen.add(p)) continue;
            duplicates.add(p);
        }
        return duplicates;
    }

    protected static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

